/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import org.eclipse.fordiac.ide.ui.widget.SafeCalculatedValueCache;
import org.eclipse.nebula.widgets.nattable.command.DisposeResourcesCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.util.ICalculatedValueCache;

public abstract class AbstractCachingDataLayer
extends DataLayer {
    private final ICalculatedValueCache cache = new SafeCalculatedValueCache((ILayer)this, true, true);

    protected AbstractCachingDataLayer(IDataProvider dataProvider) {
        super(dataProvider);
    }

    protected AbstractCachingDataLayer(IDataProvider dataProvider, int defaultColumnWidth, int defaultRowHeight) {
        super(dataProvider, defaultColumnWidth, defaultRowHeight);
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        if (this.cache != null && this.isCachedValue(columnIndex, rowIndex)) {
            Object value = this.cache.getCalculatedValue(columnIndex, rowIndex, true, () -> super.getDataValue(columnIndex, rowIndex));
            if (value == null) {
                return this.getPlaceholderValue(columnIndex, rowIndex);
            }
            return value;
        }
        return super.getDataValue(columnIndex, rowIndex);
    }

    protected abstract boolean isCachedValue(int var1, int var2);

    protected abstract Object getPlaceholderValue(int var1, int var2);

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        this.clearCache();
        super.setDataValue(columnIndex, rowIndex, newValue);
    }

    public boolean doCommand(ILayerCommand command) {
        if (command instanceof DisposeResourcesCommand && this.cache != null) {
            this.cache.killCache();
            this.cache.dispose();
        }
        return super.doCommand(command);
    }

    public void fireLayerEvent(ILayerEvent event) {
        if (event instanceof IStructuralChangeEvent) {
            this.killCache();
        } else if (event instanceof IVisualChangeEvent) {
            this.clearCache();
        }
        super.fireLayerEvent(event);
    }

    public void setDataProvider(IDataProvider dataProvider) {
        super.setDataProvider(dataProvider);
        this.clearCache();
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.clearCache();
        }
    }

    public void killCache() {
        if (this.cache != null) {
            this.cache.killCache();
        }
    }
}

