/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commands.shared;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.internal.rebase.RebaseInteractivePlan;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.op.RebaseOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIRepositoryUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commands.shared.AbstractSharedCommandHandler;
import org.eclipse.egit.ui.internal.rebase.RebaseInteractiveView;
import org.eclipse.egit.ui.internal.rebase.RebaseResultDialog;
import org.eclipse.egit.ui.internal.staging.StagingView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractRebaseCommandHandler
extends AbstractSharedCommandHandler {
    protected String jobname;
    private final String dialogMessage;

    protected AbstractRebaseCommandHandler(String jobname, String dialogMessage) {
        this.jobname = jobname;
        this.dialogMessage = dialogMessage;
    }

    protected void execute(RebaseOperation rebase) throws ExecutionException {
        Repository repository = rebase.getRepository();
        if (repository == null) {
            return;
        }
        RebaseCommand.Operation operation = rebase.getOperation();
        this.startRebaseJob(rebase, repository, operation);
    }

    private void startRebaseJob(final RebaseOperation rebase, final Repository repository, final RebaseCommand.Operation operation) {
        JobUtil.scheduleUserWorkspaceJob((IEGitOperation)rebase, (String)this.jobname, (Object)JobFamilies.REBASE, (IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                if (operation == RebaseCommand.Operation.BEGIN && !repository.getRepositoryState().equals((Object)RepositoryState.SAFE)) {
                    throw new IllegalStateException("Can't start rebase if repository state isn't SAFE");
                }
                super.aboutToRun(event);
            }

            public void done(IJobChangeEvent cevent) {
                this.finishRebaseInteractive();
                IStatus result = cevent.getJob().getResult();
                if (result == null) {
                    return;
                }
                if (operation == RebaseCommand.Operation.BEGIN && result.getSeverity() == 4) {
                    AbstractRebaseCommandHandler.this.handleBeginError(repository, result);
                } else if (result.getSeverity() == 8) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            MessageDialog.openInformation((Shell)shell, (String)UIText.AbstractRebaseCommand_DialogTitle, (String)(this).AbstractRebaseCommandHandler.this.dialogMessage);
                        }
                    });
                } else if (result.isOK()) {
                    RebaseResult.Status status = rebase.getResult().getStatus();
                    switch (status) {
                        case UNCOMMITTED_CHANGES: {
                            AbstractRebaseCommandHandler.this.handleUncommittedChanges(repository, rebase.getResult().getUncommittedChanges());
                            break;
                        }
                        case INTERACTIVE_PREPARED: {
                            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                                try {
                                    RebaseInteractiveView view = (RebaseInteractiveView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.InteractiveRebaseView");
                                    view.setInput(repository);
                                }
                                catch (PartInitException e) {
                                    Activator.logError(e.getMessage(), e);
                                }
                            });
                            break;
                        }
                        default: {
                            RebaseResultDialog.show(rebase.getResult(), repository);
                            if (operation == RebaseCommand.Operation.ABORT) {
                                this.setAmending(false, false);
                                break;
                            }
                            if (status != RebaseResult.Status.EDIT) break;
                            this.setAmending(true, true);
                        }
                    }
                }
            }

            private void setAmending(final boolean amending, final boolean openStagingView) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IViewPart view = openStagingView ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.StagingView") : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.egit.ui.StagingView");
                            if (view instanceof StagingView) {
                                final StagingView sv = (StagingView)view;
                                sv.reload(repository);
                                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        sv.setAmending(amending);
                                    }
                                });
                            }
                        }
                        catch (PartInitException e) {
                            Activator.logError(e.getMessage(), e);
                        }
                    }
                });
            }

            private void finishRebaseInteractive() {
                RebaseInteractivePlan plan = RebaseInteractivePlan.getPlan((Repository)repository);
                if (plan != null && !plan.isRebasingInteractive()) {
                    plan.dispose();
                }
            }
        });
    }

    private void handleUncommittedChanges(final Repository repository, final List<String> files) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                String repoName = RepositoryUtil.INSTANCE.getRepositoryName(repository);
                String title = MessageFormat.format(UIText.AbstractRebaseCommandHandler_cleanupDialog_title, repoName);
                if (UIRepositoryUtils.showCleanupDialog(repository, files, title, shell)) {
                    try {
                        AbstractRebaseCommandHandler.this.execute(repository);
                    }
                    catch (ExecutionException e) {
                        Activator.logError(e.getMessage(), e);
                    }
                }
            }
        });
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = AbstractRebaseCommandHandler.getRepository(event);
        this.execute(repository);
        return null;
    }

    public void execute(Repository repository) throws ExecutionException {
        RebaseOperation rebase = this.createRebaseOperation(repository);
        if (rebase != null) {
            this.execute(rebase);
        }
    }

    private void handleBeginError(Repository repository, IStatus result) {
        if (!repository.getRepositoryState().equals((Object)RepositoryState.SAFE)) {
            Throwable t = result.getException();
            try {
                new RebaseOperation(repository, RebaseCommand.Operation.ABORT).execute(null);
                Activator.showError(t.getMessage(), t);
            }
            catch (CoreException e1) {
                IStatus childStatus = Activator.createErrorStatus(e1.getMessage(), e1);
                MultiStatus mStatus = new MultiStatus("org.eclipse.egit.ui", 4, new IStatus[]{childStatus}, t.getMessage(), t);
                CoreException mStatusException = new CoreException((IStatus)mStatus);
                Activator.showError(mStatusException.getMessage(), mStatusException);
            }
        }
    }

    protected abstract RebaseOperation createRebaseOperation(Repository var1) throws ExecutionException;
}

