/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.export.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.export.FileOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.export.FilePathOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.export.ILayerExporter;
import org.eclipse.nebula.widgets.nattable.export.IOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.swt.widgets.Shell;

public class CsvExporter
implements ILayerExporter {
    private static final String CSV_FILE_EXTENSION = "*.csv";
    private static final String CSV_FILE_FILTER = "CSV (*.csv)";
    private static final String DEFAULT_EXPORT_FILE_NAME = "csv_export.csv";
    private static final String NEW_LINE_REGEX = "\\n\\r|\\r\\n|\\n|\\r";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final IOutputStreamProvider outputStreamProvider;
    private String charset = "windows-1252";
    private String delimiter = ";";
    private final StringBuilder currentRow = new StringBuilder(2048);
    private boolean rowCellInserted;
    private Charset usedCharset;

    public CsvExporter(IOutputStreamProvider outputStreamProvider) {
        this.outputStreamProvider = outputStreamProvider == null ? new FileOutputStreamProvider(DEFAULT_EXPORT_FILE_NAME, new String[]{CSV_FILE_FILTER}, new String[]{CSV_FILE_EXTENSION}) : outputStreamProvider;
    }

    public CsvExporter() {
        this((IOutputStreamProvider)null);
    }

    public CsvExporter(String filePath) {
        this.outputStreamProvider = new FilePathOutputStreamProvider(filePath);
    }

    @Override
    public OutputStream getOutputStream(Shell shell) {
        return this.outputStreamProvider.getOutputStream(shell);
    }

    @Override
    public Object getResult() {
        return this.outputStreamProvider.getResult();
    }

    @Override
    public void exportBegin(OutputStream outputStream) throws IOException {
        this.usedCharset = Charset.forName(this.charset);
    }

    @Override
    public void exportEnd(OutputStream outputStream) throws IOException {
    }

    @Override
    public void exportLayerBegin(OutputStream outputStream, String layerName) throws IOException {
    }

    @Override
    public void exportLayerEnd(OutputStream outputStream, String layerName) throws IOException {
    }

    @Override
    public void exportRowBegin(OutputStream outputStream, int rowPosition) throws IOException {
        this.currentRow.setLength(0);
        this.rowCellInserted = false;
    }

    @Override
    public void exportRowEnd(OutputStream outputStream, int rowPosition) throws IOException {
        this.currentRow.append(LINE_SEPARATOR);
        outputStream.write(this.currentRow.toString().getBytes(this.usedCharset));
    }

    @Override
    public void exportCell(OutputStream outputStream, Object exportDisplayValue, ILayerCell cell, IConfigRegistry configRegistry) throws IOException {
        if (cell.getBounds().width == 0 || cell.getBounds().height == 0) {
            return;
        }
        if (this.rowCellInserted) {
            this.currentRow.append(this.delimiter);
        } else {
            this.rowCellInserted = true;
        }
        if (exportDisplayValue != null) {
            String value = exportDisplayValue.toString();
            if ((value = value.replace("\"", "\"\"")).contains("\"") || value.contains(",") || value.split(NEW_LINE_REGEX).length > 1) {
                value = "\"" + value + "\"";
            }
            this.currentRow.append(value);
        }
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

