/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.subapptypeeditor.editors;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.application.editors.SubApplicationEditorInput;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTEditorPart;
import org.eclipse.fordiac.ide.fbtypeeditor.network.viewer.CompositeAndSubAppInstanceViewerInput;
import org.eclipse.fordiac.ide.fbtypeeditor.network.viewer.CompositeInstanceViewer;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.model.errormarker.FordiacErrorMarker;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.ui.editors.AbstractBreadCrumbEditor;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.fordiac.ide.subapptypeeditor.editors.TypedSubAppNetworkEditor;
import org.eclipse.fordiac.ide.subapptypeeditor.editors.UnTypedSubAppNetworkEditor;
import org.eclipse.fordiac.ide.subapptypeeditor.providers.TypedSubappProviderAdapterFactory;
import org.eclipse.fordiac.ide.subapptypeeditor.viewer.SubappInstanceViewer;
import org.eclipse.fordiac.ide.typeeditor.TypeEditorInput;
import org.eclipse.fordiac.ide.typemanagement.navigator.FBTypeLabelProvider;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;

public class SubAppNetworkBreadCrumbEditor
extends AbstractBreadCrumbEditor
implements IFBTEditorPart {
    private CommandStack commandStack;
    private GraphicalAnnotationModel annotationModel;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof TypeEditorInput)) {
            throw new IllegalArgumentException("SubAppNetworkBreadCrumbEditor is only suitable for TypeEditorInputs");
        }
        super.init(site, input);
        this.setTitleImage(FordiacImage.ICON_FB_NETWORK.getImage());
        this.setPartName("FB Network");
    }

    public TypeEditorInput getEditorInput() {
        return (TypeEditorInput)super.getEditorInput();
    }

    public SubAppType getType() {
        return (SubAppType)super.getType();
    }

    protected Composite createPageContainer(Composite parent) {
        Composite pageContainer = new Composite(parent, 0);
        pageContainer.setLayoutData((Object)new GridData(1808));
        return pageContainer;
    }

    protected IEditorSite createSite(IEditorPart editor) {
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        if (iWorkbenchPartSite instanceof MultiPageEditorSite) {
            MultiPageEditorSite multiPageEditorSite = (MultiPageEditorSite)iWorkbenchPartSite;
            return new MultiPageEditorSite(multiPageEditorSite.getMultiPageEditor(), editor);
        }
        return super.createSite(editor);
    }

    protected void addPages() {
        try {
            TypedSubAppNetworkEditor initialEditor = new TypedSubAppNetworkEditor();
            initialEditor.setCommonCommandStack(this.getCommandStack());
            int pagenum = this.addPage((IEditorPart)initialEditor, (IEditorInput)this.getEditorInput());
            this.getModelToEditorNumMapping().put(this.getType(), pagenum);
        }
        catch (PartInitException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
    }

    protected EditorPart createEditorPart(Object model) {
        if (model instanceof SubApp) {
            SubApp subApp = (SubApp)model;
            if (subApp.isTyped()) {
                return new SubappInstanceViewer();
            }
            UnTypedSubAppNetworkEditor editor = new UnTypedSubAppNetworkEditor();
            editor.setCommonCommandStack(this.getCommandStack());
            editor.setTypeLib(this.getEditorInput().getTypeEntry().getTypeLibrary());
            return editor;
        }
        if (model instanceof CFBInstance) {
            return new CompositeInstanceViewer();
        }
        return null;
    }

    protected IEditorInput createEditorInput(Object model) {
        if (model instanceof SubApp) {
            SubApp subApp = (SubApp)model;
            if (subApp.isTyped() || subApp.isContainedInTypedInstance()) {
                return new CompositeAndSubAppInstanceViewerInput((FBNetworkElement)subApp);
            }
            return new SubApplicationEditorInput(subApp);
        }
        if (model instanceof CFBInstance) {
            return new CompositeAndSubAppInstanceViewerInput((FBNetworkElement)((FB)model));
        }
        return null;
    }

    protected AdapterFactoryContentProvider createBreadcrumbContentProvider() {
        return new AdapterFactoryContentProvider((AdapterFactory)new TypedSubappProviderAdapterFactory());
    }

    protected AdapterFactoryLabelProvider createBreadcrumbLabelProvider() {
        return new FBTypeLabelProvider();
    }

    protected Object getInitialModel(String itemPath) {
        return this.getType();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public CommandStack getCommandStack() {
        return this.commandStack;
    }

    public String getContributorId() {
        return "property.contributor.fb";
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public boolean outlineSelectionChanged(Object selectedElement) {
        if (selectedElement instanceof EObject) {
            EObject eObj = (EObject)selectedElement;
            if (EcoreUtil.isAncestor((EObject)this.getType().getFBNetwork(), (EObject)eObj)) {
                if (selectedElement instanceof FBNetwork) {
                    FBNetwork fbn = (FBNetwork)selectedElement;
                    selectedElement = fbn.eContainer();
                }
                if (selectedElement instanceof FBNetworkElement || selectedElement instanceof SubAppType || selectedElement instanceof VarDeclaration) {
                    FB refElement = null;
                    if (selectedElement instanceof FB) {
                        FB fb;
                        refElement = fb = (FB)selectedElement;
                        selectedElement = refElement.eContainer().eContainer();
                    } else if (selectedElement instanceof SubApp) {
                        SubApp subApp = (SubApp)selectedElement;
                        refElement = subApp;
                        selectedElement = refElement.eContainer().eContainer();
                    } else if (selectedElement instanceof VarDeclaration) {
                        VarDeclaration varDecl = (VarDeclaration)selectedElement;
                        refElement = varDecl;
                        selectedElement = varDecl.eContainer().eContainer();
                    }
                    this.getBreadcrumb().setInput(selectedElement);
                    if (refElement != null) {
                        HandlerHelper.selectElement((Object)refElement, (IEditorPart)this.getActiveEditor());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void setCommonCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    public boolean isMarkerTarget(IMarker marker) {
        return FordiacErrorMarker.markerTargetsFBNetworkElement((IMarker)marker) || FordiacErrorMarker.markerTargetsErrorMarkerInterface((IMarker)marker) || FordiacErrorMarker.markerTargetsConnection((IMarker)marker) || FordiacErrorMarker.markerTargetsValue((IMarker)marker);
    }

    public void setInput(IEditorInput input) {
        this.checkEditorInput(input);
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        if (iWorkbenchPartSite instanceof MultiPageEditorSite) {
            MultiPageEditorSite multiPageEditorSite = (MultiPageEditorSite)iWorkbenchPartSite;
            this.annotationModel = (GraphicalAnnotationModel)multiPageEditorSite.getMultiPageEditor().getAdapter(GraphicalAnnotationModel.class);
        }
        this.pages.stream().filter(IReusableEditor.class::isInstance).map(IReusableEditor.class::cast).forEach(e -> e.setInput(e.getEditorInput()));
        super.setInputWithNotify(input);
    }

    public void reloadType() {
        SubAppType subAppType = this.getType();
        if (subAppType instanceof SubAppType) {
            SubAppType subAppType2 = subAppType;
            String path = this.getBreadcrumb().serializePath();
            this.removePage(this.getActivePage());
            this.createPages();
            if (!this.getBreadcrumb().openPath(path, subAppType2)) {
                this.getBreadcrumb().setInput((Object)subAppType2);
                this.showReloadErrorMessage(path, "Showing subapp root.");
            }
        } else {
            EditorUtils.CloseEditor.run((IEditorPart)this);
        }
    }

    public Object getSelectableObject() {
        GraphicalViewer viewer = this.getAdapter(GraphicalViewer.class);
        return viewer.getRootEditPart();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == GraphicalAnnotationModel.class) {
            return adapter.cast(this.annotationModel);
        }
        if (adapter == LibraryElement.class) {
            return adapter.cast(this.getType());
        }
        return (T)super.getAdapter(adapter);
    }
}

