/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.util.List;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;

public class TargetInterfaceElement
implements Comparable<TargetInterfaceElement> {
    private final IInterfaceElement refElement;
    private final IInterfaceElement host;

    public static TargetInterfaceElement createFor(IInterfaceElement host, IInterfaceElement refElement, FBNetwork parentNW) {
        SubApp subapp;
        FBNetworkElement fBNetworkElement;
        if (refElement.getFBNetworkElement() == null || (fBNetworkElement = refElement.getFBNetworkElement()) instanceof SubApp && (subapp = (SubApp)fBNetworkElement).getSubAppNetwork() == parentNW) {
            return new SubappTargetInterfaceElement(host, refElement);
        }
        return new TargetInterfaceElement(host, refElement);
    }

    private TargetInterfaceElement(IInterfaceElement host, IInterfaceElement refElement) {
        this.host = host;
        this.refElement = refElement;
    }

    public IInterfaceElement getRefElement() {
        return this.refElement;
    }

    public IInterfaceElement getHost() {
        return this.host;
    }

    public String getRefPinFullName() {
        StringBuilder retVal = new StringBuilder();
        FBNetworkElement fbelement = this.getRefElement().getFBNetworkElement();
        if (fbelement != null) {
            FBNetworkElement parent = fbelement.getOuterFBNetworkElement();
            if (parent != null) {
                FBNetworkElement grandParent = parent.getOuterFBNetworkElement();
                if (grandParent != null && this.getHost().getFBNetworkElement() != null && this.getHost().getFBNetworkElement() != grandParent && this.getHost().getFBNetworkElement().getOuterFBNetworkElement() != grandParent) {
                    retVal.append(grandParent.getName());
                    retVal.append('.');
                }
                retVal.append(parent.getName());
                retVal.append('.');
            }
            retVal.append(fbelement.getName());
            retVal.append('.');
        }
        retVal.append(this.getRefElement().getName());
        return retVal.toString();
    }

    @Override
    public int compareTo(TargetInterfaceElement other) {
        if (other instanceof SubappTargetInterfaceElement) {
            return 1;
        }
        return this.getRefPinFullName().compareTo(other.getRefPinFullName());
    }

    public static class GroupTargetInterfaceElement
    extends SubappTargetInterfaceElement {
        final SubApp subapp;
        final List<IInterfaceElement> refElements;

        public GroupTargetInterfaceElement(IInterfaceElement host, List<IInterfaceElement> refElements, SubApp subapp) {
            super(host, refElements.getFirst());
            this.subapp = subapp;
            this.refElements = refElements;
        }

        @Override
        public String getRefPinFullName() {
            return this.subapp.getName() + ": " + this.refElements.size();
        }

        public List<IInterfaceElement> getRefElements() {
            return this.refElements;
        }
    }

    public static class SubappTargetInterfaceElement
    extends TargetInterfaceElement {
        private SubappTargetInterfaceElement(IInterfaceElement host, IInterfaceElement refElement) {
            super(host, refElement);
        }

        @Override
        public String getRefPinFullName() {
            return this.getRefElement().getName();
        }

        @Override
        public int compareTo(TargetInterfaceElement other) {
            if (other instanceof SubappTargetInterfaceElement) {
                return this.getRefPinFullName().compareTo(other.getRefPinFullName());
            }
            return -1;
        }
    }
}

