/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisteredServer;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class RegisterServer2Request
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12193");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12211");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12199");
    private final RequestHeader requestHeader;
    private final RegisteredServer server;
    private final ExtensionObject[] discoveryConfiguration;

    public RegisterServer2Request(RequestHeader requestHeader, RegisteredServer server, ExtensionObject[] discoveryConfiguration) {
        this.requestHeader = requestHeader;
        this.server = server;
        this.discoveryConfiguration = discoveryConfiguration;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public RegisteredServer getServer() {
        return this.server;
    }

    public ExtensionObject[] getDiscoveryConfiguration() {
        return this.discoveryConfiguration;
    }

    protected RegisterServer2Request(RegisterServer2RequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((RegisterServer2RequestBuilder)b).requestHeader;
        this.server = ((RegisterServer2RequestBuilder)b).server;
        this.discoveryConfiguration = ((RegisterServer2RequestBuilder)b).discoveryConfiguration;
    }

    public static RegisterServer2RequestBuilder<?, ?> builder() {
        return new RegisterServer2RequestBuilderImpl();
    }

    public RegisterServer2RequestBuilder<?, ?> toBuilder() {
        return new RegisterServer2RequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisterServer2Request)) {
            return false;
        }
        RegisterServer2Request other = (RegisterServer2Request)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        RegisteredServer this$server = this.getServer();
        RegisteredServer other$server = other.getServer();
        if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
            return false;
        }
        return Arrays.deepEquals(this.getDiscoveryConfiguration(), other.getDiscoveryConfiguration());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegisterServer2Request;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        RegisteredServer $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getDiscoveryConfiguration());
        return result;
    }

    @Override
    public String toString() {
        return "RegisterServer2Request(requestHeader=" + this.getRequestHeader() + ", server=" + this.getServer() + ", discoveryConfiguration=" + Arrays.deepToString(this.getDiscoveryConfiguration()) + ")";
    }

    private static final class RegisterServer2RequestBuilderImpl
    extends RegisterServer2RequestBuilder<RegisterServer2Request, RegisterServer2RequestBuilderImpl> {
        private RegisterServer2RequestBuilderImpl() {
        }

        @Override
        protected RegisterServer2RequestBuilderImpl self() {
            return this;
        }

        @Override
        public RegisterServer2Request build() {
            return new RegisterServer2Request(this);
        }
    }

    public static abstract class RegisterServer2RequestBuilder<C extends RegisterServer2Request, B extends RegisterServer2RequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private RegisteredServer server;
        private ExtensionObject[] discoveryConfiguration;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RegisterServer2RequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(RegisterServer2Request instance, RegisterServer2RequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.server(instance.server);
            b.discoveryConfiguration(instance.discoveryConfiguration);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B server(RegisteredServer server) {
            this.server = server;
            return (B)this.self();
        }

        public B discoveryConfiguration(ExtensionObject[] discoveryConfiguration) {
            this.discoveryConfiguration = discoveryConfiguration;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "RegisterServer2Request.RegisterServer2RequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", server=" + this.server + ", discoveryConfiguration=" + Arrays.deepToString(this.discoveryConfiguration) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<RegisterServer2Request> {
        @Override
        public Class<RegisterServer2Request> getType() {
            return RegisterServer2Request.class;
        }

        @Override
        public RegisterServer2Request decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            RegisteredServer server = (RegisteredServer)decoder.readStruct("Server", RegisteredServer.TYPE_ID);
            ExtensionObject[] discoveryConfiguration = decoder.readExtensionObjectArray("DiscoveryConfiguration");
            return new RegisterServer2Request(requestHeader, server, discoveryConfiguration);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, RegisterServer2Request value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeStruct("Server", (Object)value.getServer(), RegisteredServer.TYPE_ID);
            encoder.writeExtensionObjectArray("DiscoveryConfiguration", value.getDiscoveryConfiguration());
        }
    }
}

