/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.command;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.mapping.MappedObjectState;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.emf.mapping.command.CreateMappingCommand;
import org.eclipse.emf.mapping.domain.MappingDomain;

public class AddOverrideCommand
extends AbstractCommand {
    protected MappingDomain mappingDomain;
    protected AddCommand addCommand;
    protected Command mapCommand;

    public AddOverrideCommand(MappingDomain domain, AddCommand addCommand) {
        super(addCommand.doGetLabel(), addCommand.doGetDescription());
        this.mappingDomain = domain;
        this.addCommand = addCommand;
    }

    protected boolean prepare() {
        return this.addCommand.doCanExecute();
    }

    public void execute() {
        this.addCommand.doExecute();
        MappingRoot mappingRoot = this.mappingDomain.getMappingRoot();
        CompoundCommand subcommands = new CompoundCommand();
        for (Object addition : this.addCommand.getCollection()) {
            TreeIterator objects = this.mappingDomain.treeIterator(addition);
            while (objects.hasNext()) {
                Object object = objects.next();
                MappedObjectState mappedObjectState = mappingRoot.getMappedObjectState(object);
                Object originatingInput = mappedObjectState.getOriginatingInput();
                if (originatingInput == null) {
                    mappedObjectState.setOutput();
                    continue;
                }
                if (!mappingRoot.isAttachedObject(object)) continue;
                this.mapOutputObject(object, originatingInput, subcommands);
            }
        }
        this.mapCommand = !subcommands.isEmpty() ? subcommands.unwrap() : null;
    }

    protected void mapOutputObject(Object outputObject, Object originatingInput, CompoundCommand subcommands) {
        subcommands.appendAndExecute(CreateMappingCommand.create(this.mappingDomain, originatingInput, outputObject));
    }

    public void undo() {
        if (this.mapCommand != null) {
            this.mapCommand.undo();
        }
        this.addCommand.doUndo();
    }

    public void redo() {
        this.addCommand.doRedo();
        if (this.mapCommand != null) {
            this.mapCommand.redo();
        }
    }

    public void dispose() {
        if (this.mapCommand != null) {
            this.mapCommand.dispose();
        }
        this.addCommand.doDispose();
    }

    public Collection<?> getResult() {
        ArrayList result = new ArrayList();
        result.addAll(this.addCommand.doGetResult());
        if (this.mapCommand != null) {
            result.addAll(this.mapCommand.getResult());
        }
        return result;
    }

    public Collection<?> getAffectedObjects() {
        ArrayList result = new ArrayList();
        result.addAll(this.addCommand.doGetAffectedObjects());
        if (this.mapCommand != null) {
            result.addAll(this.mapCommand.getAffectedObjects());
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (mappingDomain: " + this.mappingDomain + ")");
        result.append(" (mapCommand: " + this.mapCommand + ")");
        return result.toString();
    }
}

