/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import java.util.List;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.config.RenderErrorHandling;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ControlDecorationProvider;
import org.eclipse.nebula.widgets.nattable.edit.editor.EditorSelectionEnum;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class StyledTextCellEditor
extends AbstractCellEditor {
    private StyledText text = null;
    private boolean editable = true;
    private final boolean commitOnUpDown;
    private final boolean commitOnLeftRight;
    private final boolean moveSelectionOnEnter;
    private EditorSelectionEnum selectionMode;
    protected final ControlDecorationProvider decorationProvider = new ControlDecorationProvider();
    private IEditErrorHandler inputConversionErrorHandler = new RenderErrorHandling(this.decorationProvider);
    private IEditErrorHandler inputValidationErrorHandler = new RenderErrorHandling(this.decorationProvider);
    protected boolean commitOnEnter = true;
    private boolean commitWithCtrlKey = false;
    protected IControlContentAdapter controlContentAdapter;
    protected IContentProposalProvider proposalProvider;
    protected KeyStroke keyStroke;
    protected char[] autoActivationCharacters;
    protected int proposalAcceptanceStyle = 2;
    protected int autoActivationDelay = 0;
    protected ContentProposalAdapter contentProposalAdapter;

    public StyledTextCellEditor() {
        this(false);
    }

    public StyledTextCellEditor(boolean commitOnUpDown) {
        this(commitOnUpDown, false);
    }

    public StyledTextCellEditor(boolean commitOnUpDown, boolean moveSelectionOnEnter) {
        this(commitOnUpDown, moveSelectionOnEnter, false);
    }

    public StyledTextCellEditor(boolean commitOnUpDown, boolean moveSelectionOnEnter, boolean commitOnLeftRight) {
        this.commitOnUpDown = commitOnUpDown;
        this.moveSelectionOnEnter = moveSelectionOnEnter;
        this.commitOnLeftRight = commitOnLeftRight;
    }

    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        IEditErrorHandler iEditErrorHandler;
        this.text = this.createEditorControl(parent);
        if (originalCanonicalValue instanceof Character) {
            this.text.setText(originalCanonicalValue.toString());
            this.selectText(this.selectionMode != null ? this.selectionMode : EditorSelectionEnum.END);
        } else {
            this.setCanonicalValue(originalCanonicalValue);
            this.selectText(this.selectionMode != null ? this.selectionMode : EditorSelectionEnum.ALL);
        }
        if (!this.isEditable()) {
            this.text.setEditable(false);
        }
        this.decorationProvider.createErrorDecorationIfRequired((Control)this.text);
        IEditErrorHandler iEditErrorHandler2 = this.inputConversionErrorHandler;
        if (iEditErrorHandler2 instanceof RenderErrorHandling) {
            RenderErrorHandling renderErrorHandling = (RenderErrorHandling)iEditErrorHandler2;
            IStyle conversionErrorStyle = (IStyle)this.configRegistry.getConfigAttribute(EditConfigAttributes.CONVERSION_ERROR_STYLE, DisplayMode.EDIT, (List)this.labelStack);
            renderErrorHandling.setErrorStyle(conversionErrorStyle);
        }
        if ((iEditErrorHandler = this.inputValidationErrorHandler) instanceof RenderErrorHandling) {
            RenderErrorHandling renderErrorHandling = (RenderErrorHandling)iEditErrorHandler;
            IStyle validationErrorStyle = (IStyle)this.configRegistry.getConfigAttribute(EditConfigAttributes.VALIDATION_ERROR_STYLE, DisplayMode.EDIT, (List)this.labelStack);
            renderErrorHandling.setErrorStyle(validationErrorStyle);
        }
        if (this.controlContentAdapter != null) {
            this.configureContentProposalAdapter(new ContentProposalAdapter((Control)this.text, this.controlContentAdapter, this.proposalProvider, this.keyStroke, this.autoActivationCharacters));
        }
        this.text.forceFocus();
        return this.text;
    }

    public String getEditorValue() {
        return this.text.getText();
    }

    public void setEditorValue(Object value) {
        this.text.setText(value != null && value.toString().length() > 0 ? value.toString() : "");
    }

    public Control getEditorControl() {
        return this.text;
    }

    public StyledText createEditorControl(Composite parent) {
        int style = HorizontalAlignmentEnum.getSWTStyle((IStyle)this.cellStyle);
        if (this.editMode == EditModeEnum.DIALOG) {
            style |= 0x800;
        }
        return this.createEditorControl(parent, style);
    }

    protected StyledText createEditorControl(Composite parent, int style) {
        StyledText textControl = this.createStyledText(parent, style);
        textControl.setBackground((Color)this.cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        textControl.setForeground((Color)this.cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
        textControl.setFont((Font)this.cellStyle.getAttributeValue(CellStyleAttributes.FONT));
        textControl.setCursor(Display.getDefault().getSystemCursor(19));
        textControl.addVerifyKeyListener(event -> {
            if (event.doit && !this.isProposalPopupOpen()) {
                if (this.isCommitOnEnter() && (event.keyCode == 13 || event.keyCode == 0x1000050)) {
                    boolean commit;
                    boolean bl = commit = event.stateMask != SWT.MOD3;
                    if (this.isCommitWithCtrlKey()) {
                        commit = event.stateMask == SWT.MOD1;
                    }
                    SelectionLayer.MoveDirectionEnum move = SelectionLayer.MoveDirectionEnum.NONE;
                    if (this.moveSelectionOnEnter && this.editMode == EditModeEnum.INLINE) {
                        if (event.stateMask == 0) {
                            move = SelectionLayer.MoveDirectionEnum.DOWN;
                        } else if (event.stateMask == SWT.MOD2) {
                            move = SelectionLayer.MoveDirectionEnum.UP;
                        }
                    }
                    if (commit) {
                        this.commit(move);
                        event.doit = false;
                    }
                    if (this.editMode == EditModeEnum.DIALOG) {
                        parent.forceFocus();
                    }
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    this.close();
                    event.doit = false;
                } else if ((this.commitOnUpDown || this.commitOnLeftRight) && this.editMode == EditModeEnum.INLINE) {
                    Text control = (Text)event.widget;
                    if (this.commitOnUpDown && event.keyCode == 0x1000001) {
                        this.commit(SelectionLayer.MoveDirectionEnum.UP);
                        event.doit = false;
                    } else if (this.commitOnUpDown && event.keyCode == 0x1000002) {
                        this.commit(SelectionLayer.MoveDirectionEnum.DOWN);
                        event.doit = false;
                    } else if (this.commitOnLeftRight && control.getSelectionCount() == 0 && event.keyCode == 0x1000003 && control.getCaretPosition() == 0) {
                        this.commit(SelectionLayer.MoveDirectionEnum.LEFT);
                        event.doit = false;
                    } else if (this.commitOnLeftRight && control.getSelectionCount() == 0 && event.keyCode == 0x1000004 && control.getCaretPosition() == control.getCharCount()) {
                        this.commit(SelectionLayer.MoveDirectionEnum.RIGHT);
                        event.doit = false;
                    }
                }
            }
        });
        textControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
            }

            public void keyReleased(KeyEvent e) {
                try {
                    Object canonicalValue = StyledTextCellEditor.this.getCanonicalValue(StyledTextCellEditor.this.inputConversionErrorHandler);
                    StyledTextCellEditor.this.validateCanonicalValue(canonicalValue, StyledTextCellEditor.this.inputValidationErrorHandler);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return textControl;
    }

    protected StyledText createStyledText(Composite parent, int style) {
        return new StyledText(parent, style);
    }

    public void close() {
        if (this.inputConversionErrorHandler != null) {
            this.inputConversionErrorHandler.removeError((ICellEditor)this);
        }
        if (this.inputValidationErrorHandler != null) {
            this.inputValidationErrorHandler.removeError((ICellEditor)this);
        }
        super.close();
        this.decorationProvider.dispose();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public final EditorSelectionEnum getSelectionMode() {
        return this.selectionMode;
    }

    public final void setSelectionMode(EditorSelectionEnum selectionMode) {
        this.selectionMode = selectionMode;
    }

    private void selectText(EditorSelectionEnum selectionMode) {
        int textLength = this.text.getText().length();
        if (textLength > 0) {
            if (selectionMode == EditorSelectionEnum.ALL) {
                this.text.setSelection(0, textLength);
            } else if (selectionMode == EditorSelectionEnum.END) {
                this.text.setSelection(textLength, textLength);
            } else if (selectionMode == EditorSelectionEnum.START) {
                this.text.setSelection(0);
            }
        }
    }

    public ControlDecorationProvider getDecorationProvider() {
        return this.decorationProvider;
    }

    public void setErrorDecorationEnabled(boolean enabled) {
        this.decorationProvider.setErrorDecorationEnabled(enabled);
    }

    public void showErrorDecorationHover(String customErrorText) {
        this.decorationProvider.showErrorDecorationHover(customErrorText);
    }

    public void setFieldDecorationId(String fieldDecorationId) {
        this.decorationProvider.setFieldDecorationId(fieldDecorationId);
    }

    public void setDecorationPositionOverride(int decorationPositionOverride) {
        this.decorationProvider.setDecorationPositionOverride(decorationPositionOverride);
    }

    public IEditErrorHandler getInputConversionErrorHandler() {
        return this.inputConversionErrorHandler;
    }

    public void setInputConversionErrorHandler(IEditErrorHandler inputConversionErrorHandler) {
        this.inputConversionErrorHandler = inputConversionErrorHandler;
    }

    public IEditErrorHandler getInputValidationErrorHandler() {
        return this.inputValidationErrorHandler;
    }

    public void setInputValidationErrorHandler(IEditErrorHandler inputValidationErrorHandler) {
        this.inputValidationErrorHandler = inputValidationErrorHandler;
    }

    public void enableContentProposal(IControlContentAdapter controlContentAdapter, IContentProposalProvider proposalProvider, KeyStroke keyStroke, char[] autoActivationCharacters) {
        this.enableContentProposal(controlContentAdapter, proposalProvider, keyStroke, autoActivationCharacters, 2, 0);
    }

    public void enableContentProposal(IControlContentAdapter controlContentAdapter, IContentProposalProvider proposalProvider, KeyStroke keyStroke, char[] autoActivationCharacters, int proposalAcceptanceStyle, int autoActivationDelay) {
        this.controlContentAdapter = controlContentAdapter;
        this.proposalProvider = proposalProvider;
        this.keyStroke = keyStroke;
        this.autoActivationCharacters = autoActivationCharacters;
        this.proposalAcceptanceStyle = proposalAcceptanceStyle;
        this.autoActivationDelay = autoActivationDelay;
        this.traverseListener = new AbstractCellEditor.InlineTraverseListener(this){

            public void keyTraversed(TraverseEvent event) {
                if (!StyledTextCellEditor.this.isProposalPopupOpen()) {
                    super.keyTraversed(event);
                }
            }
        };
    }

    protected void configureContentProposalAdapter(ContentProposalAdapter contentProposalAdapter) {
        this.contentProposalAdapter = contentProposalAdapter;
        contentProposalAdapter.addContentProposalListener(proposal -> {
            if (this.editMode == EditModeEnum.INLINE) {
                this.commit(SelectionLayer.MoveDirectionEnum.NONE);
                this.contentProposalAdapter = null;
            }
        });
        contentProposalAdapter.addContentProposalListener(new IContentProposalListener2(){

            public void proposalPopupClosed(ContentProposalAdapter adapter) {
                FocusListener focusListener = StyledTextCellEditor.this.focusListener;
                if (focusListener instanceof AbstractCellEditor.InlineFocusListener) {
                    AbstractCellEditor.InlineFocusListener inlineFL = (AbstractCellEditor.InlineFocusListener)focusListener;
                    inlineFL.handleFocusChanges = true;
                }
            }

            public void proposalPopupOpened(ContentProposalAdapter adapter) {
                FocusListener focusListener = StyledTextCellEditor.this.focusListener;
                if (focusListener instanceof AbstractCellEditor.InlineFocusListener) {
                    AbstractCellEditor.InlineFocusListener inlineFL = (AbstractCellEditor.InlineFocusListener)focusListener;
                    inlineFL.handleFocusChanges = false;
                }
            }
        });
        contentProposalAdapter.setProposalAcceptanceStyle(this.proposalAcceptanceStyle);
        contentProposalAdapter.setAutoActivationDelay(this.autoActivationDelay);
    }

    public boolean isCommitOnEnter() {
        return this.commitOnEnter;
    }

    public void setCommitOnEnter(boolean commitOnEnter) {
        this.commitOnEnter = commitOnEnter;
    }

    public boolean isCommitWithCtrlKey() {
        return this.commitWithCtrlKey;
    }

    public void setCommitWithCtrlKey(boolean commitWithCtrlKey) {
        this.commitWithCtrlKey = commitWithCtrlKey;
    }

    protected boolean isProposalPopupOpen() {
        return this.contentProposalAdapter != null && this.contentProposalAdapter.isProposalPopupOpen();
    }
}

