/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.ArrayType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.eval.EvaluatorPrepareException;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Method;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.TextAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.TextMethod;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.search.ISearchContext;
import org.eclipse.fordiac.ide.model.search.LiveSearchContext;
import org.eclipse.fordiac.ide.model.search.Messages;
import org.eclipse.fordiac.ide.model.search.ModelQuerySpec;
import org.eclipse.fordiac.ide.model.search.ModelSearchPattern;
import org.eclipse.fordiac.ide.model.search.ModelSearchResult;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ModelSearchQuery
implements ISearchQuery {
    private final ModelQuerySpec modelQuerySpec;
    private final ModelSearchPattern pattern;
    private ModelSearchResult searchResult;
    private boolean isIncompleteResult = false;

    public ModelSearchQuery(ModelQuerySpec modelQuerySpec) {
        this.modelQuerySpec = modelQuerySpec;
        this.pattern = new ModelSearchPattern(modelQuerySpec);
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.getSearchResult().clear();
        List<ISearchContext> searchRootSystems = this.getSearchContexts();
        try {
            this.performSearch(searchRootSystems, monitor);
        }
        catch (SearchCanceledException e) {
            return Status.CANCEL_STATUS;
        }
        Display.getDefault().asyncExec(() -> ((SearchView)NewSearchUI.getSearchResultView()).showSearchResult((ISearchResult)this.getSearchResult()));
        if (this.isIncompleteResult) {
            Display.getDefault().asyncExec(() -> MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.STSearchErrorDialog_Title, (String)Messages.STSearchErrorDialog_Body));
        }
        return Status.OK_STATUS;
    }

    private List<ISearchContext> getSearchContexts() {
        if (this.modelQuerySpec.scope() == ModelQuerySpec.SearchScope.PROJECT && this.modelQuerySpec.project() != null) {
            return Arrays.asList(new LiveSearchContext(this.modelQuerySpec.project()));
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return Arrays.stream(root.getProjects()).filter(IProject::isOpen).map(LiveSearchContext::new).map(ISearchContext.class::cast).toList();
    }

    private void performSearch(List<ISearchContext> searchContexts, IProgressMonitor monitor) {
        for (ISearchContext context : searchContexts) {
            context.getTypes().forEach(libraryElementURI -> {
                LibraryElement libraryElement = context.getLibraryElement((URI)libraryElementURI);
                if (libraryElement instanceof AutomationSystem) {
                    AutomationSystem sys = (AutomationSystem)libraryElement;
                    this.searchSystem(sys, monitor);
                } else if (libraryElement != null) {
                    if (this.matchTypeEntry(libraryElement, monitor)) {
                        this.searchResult.addResult((EObject)libraryElement);
                    }
                } else {
                    FordiacLogHelper.logWarning((String)("Could not load model for: " + libraryElementURI.toString()));
                }
            });
        }
    }

    private void searchSystem(AutomationSystem sys, IProgressMonitor monitor) {
        for (Application app : sys.getApplication()) {
            this.searchApplication(app, monitor);
        }
        this.searchResources(sys, monitor);
    }

    @Deprecated
    public void searchApplication(Application app) {
        this.searchApplication(app, null);
    }

    private void searchApplication(Application app, IProgressMonitor monitor) {
        if (this.matchEObject((INamedElement)app, monitor)) {
            this.searchResult.addResult((EObject)app);
        }
        this.searchFBNetwork(app.getFBNetwork(), new ArrayList<FBNetworkElement>(), monitor);
    }

    private void searchFBNetwork(FBNetwork network, List<FBNetworkElement> path, IProgressMonitor monitor) {
        for (FBNetworkElement fbnetworkElement : network.getNetworkElements()) {
            List<IInterfaceElement> matchingPins;
            SubApp subApp;
            ConfigurableFB conf;
            FBType fBType;
            if (this.matchEObject((INamedElement)fbnetworkElement, monitor)) {
                if (!path.isEmpty()) {
                    this.searchResult.getDictionary().addEntry(fbnetworkElement, path);
                }
                this.searchResult.addResult((EObject)fbnetworkElement);
            }
            if ((fBType = fbnetworkElement.getType()) instanceof BaseFBType) {
                BaseFBType type = (BaseFBType)fBType;
                for (FB fb : type.getInternalFbs()) {
                    if (!this.matchEObject((INamedElement)fb, monitor)) continue;
                    this.searchResult.getDictionary().addEntry((FBNetworkElement)fb, ModelSearchQuery.allocatePathList(path, fbnetworkElement));
                    this.searchResult.addResult((EObject)fb);
                }
            }
            if (fbnetworkElement instanceof ConfigurableFB && this.matchEObject((INamedElement)(conf = (ConfigurableFB)fbnetworkElement).getDataType(), monitor)) {
                this.searchResult.addResult((EObject)conf);
            }
            if (fbnetworkElement instanceof SubApp && !(subApp = (SubApp)fbnetworkElement).isTyped() && subApp.getSubAppNetwork() != null) {
                this.searchFBNetwork(subApp.getSubAppNetwork(), path, monitor);
            }
            if (fbnetworkElement.getInterface() == null) continue;
            if (this.modelQuerySpec.checkPinName() && !(matchingPins = fbnetworkElement.getInterface().getAllInterfaceElements().stream().filter(pin -> pin.getName() != null && this.compareStrings(pin.getName())).toList()).isEmpty()) {
                if (!path.isEmpty()) {
                    this.searchResult.getDictionary().addEntry(fbnetworkElement, path);
                }
                this.searchResult.addResults(matchingPins);
            }
            if (!this.modelQuerySpec.checkType()) continue;
            this.searchInterface(fbnetworkElement.getInterface(), monitor);
        }
    }

    private static List<FBNetworkElement> allocatePathList(List<FBNetworkElement> path, FBNetworkElement elem) {
        ArrayList<FBNetworkElement> list = new ArrayList<FBNetworkElement>(path);
        list.add(elem);
        return list;
    }

    private void searchResources(AutomationSystem sys, IProgressMonitor monitor) {
        for (Device dev : sys.getSystemConfiguration().getDevices()) {
            if (this.matchEObject((INamedElement)dev, monitor)) {
                this.searchResult.addResult((EObject)dev);
            }
            for (Resource res : dev.getResource()) {
                if (!this.matchEObject((INamedElement)res, monitor)) continue;
                this.searchResult.addResult((EObject)res);
            }
        }
    }

    private boolean matchTypeEntry(LibraryElement elem, IProgressMonitor monitor) {
        FBType type;
        LibraryElement libraryElement = elem;
        Objects.requireNonNull(libraryElement);
        LibraryElement libraryElement2 = libraryElement;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompositeFBType.class, BaseFBType.class, ArrayType.class, StructuredType.class, AttributeDeclaration.class}, (Object)libraryElement2, n)) {
            case 0: {
                CompositeFBType comp = (CompositeFBType)libraryElement2;
                this.searchFBNetwork(comp.getFBNetwork(), new ArrayList<FBNetworkElement>(), monitor);
                break;
            }
            case 1: {
                BaseFBType type2 = (BaseFBType)libraryElement2;
                for (FB fb : type2.getInternalFbs()) {
                    if (!this.matchEObject((INamedElement)fb, monitor)) continue;
                    this.searchResult.addResult((EObject)fb);
                }
                for (VarDeclaration varDecl : type2.getInternalVars()) {
                    if (!this.matchEObject((INamedElement)varDecl, monitor)) continue;
                    this.searchResult.addResult((EObject)varDecl);
                }
                for (Algorithm algo : type2.getAlgorithm()) {
                    if (!this.matchEObject((INamedElement)algo, monitor)) continue;
                    this.searchResult.addResult((EObject)algo);
                }
                for (Method meth : type2.getMethods()) {
                    if (!this.matchEObject((INamedElement)meth, monitor)) continue;
                    this.searchResult.addResult((EObject)meth);
                }
                break;
            }
            case 2: {
                ArrayType array = (ArrayType)libraryElement2;
                DataType base = array.getBaseType();
                if (!this.matchEObject((INamedElement)base, monitor)) break;
                this.searchResult.addResult((EObject)base);
                break;
            }
            case 3: {
                StructuredType struct = (StructuredType)libraryElement2;
                this.matchStruct(struct, monitor);
                break;
            }
            case 4: {
                AttributeDeclaration attDecl = (AttributeDeclaration)libraryElement2;
                AnyDerivedType anyDerivedType = attDecl.getType();
                if (anyDerivedType instanceof StructuredType) {
                    StructuredType struct = (StructuredType)anyDerivedType;
                    this.matchStruct(struct, monitor);
                    break;
                }
                if (!this.matchEObject((INamedElement)attDecl.getType(), monitor)) break;
                this.searchResult.addResult((EObject)attDecl.getType());
                break;
            }
        }
        if (elem instanceof FBType && (type = (FBType)elem).getInterfaceList() != null) {
            this.searchInterface(type.getInterfaceList(), monitor);
        }
        return this.matchEObject((INamedElement)elem, monitor);
    }

    private void matchStruct(StructuredType struct, IProgressMonitor monitor) {
        for (VarDeclaration varDecl : struct.getMemberVariables()) {
            if (varDecl.isArray()) {
                if (!this.matchEObject((INamedElement)varDecl.getType(), monitor)) continue;
                this.searchResult.addResult((EObject)varDecl);
                continue;
            }
            if (!this.matchEObject((INamedElement)varDecl, monitor)) continue;
            this.searchResult.addResult((EObject)varDecl);
        }
    }

    private void searchInterface(InterfaceList interfaceList, IProgressMonitor monitor) {
        Stream.concat(Stream.concat(interfaceList.getInputs(), interfaceList.getOutputVars().stream()), Stream.concat(interfaceList.getEventOutputs().stream(), interfaceList.getPlugs().stream())).filter(modelElement -> this.matchEObject((INamedElement)modelElement, monitor)).forEach(this.searchResult::addResult);
    }

    private boolean matchEObject(INamedElement modelElement, IProgressMonitor monitor) {
        SearchCanceledException.throwIfCanceled(monitor);
        if (this.modelQuerySpec.checkInstanceName()) {
            boolean matchInstanceName;
            String name = modelElement.getName();
            boolean bl = matchInstanceName = name != null && this.compareStrings(name);
            if (matchInstanceName) {
                return true;
            }
        }
        if (this.modelQuerySpec.checkComments()) {
            boolean matchComment;
            String comment = modelElement.getComment();
            boolean bl = matchComment = comment != null && this.compareStrings(comment);
            if (matchComment) {
                return true;
            }
        }
        if (this.modelQuerySpec.checkType()) {
            if (modelElement instanceof FunctionFBType) {
                return this.matchInST(modelElement);
            }
            if (modelElement instanceof TypedConfigureableObject) {
                TypedConfigureableObject config = (TypedConfigureableObject)modelElement;
                return this.compareStrings(config.getTypeName()) || config.getTypeEntry() != null && this.compareStrings(config.getTypeEntry().getFullTypeName());
            }
            if (modelElement instanceof LibraryElement) {
                LibraryElement namElem = (LibraryElement)modelElement;
                return this.compareStrings(namElem.getName()) || namElem.getTypeEntry() != null && this.compareStrings(namElem.getTypeEntry().getFullTypeName());
            }
            if (modelElement instanceof VarDeclaration) {
                VarDeclaration varDecl = (VarDeclaration)modelElement;
                return this.compareStrings(varDecl.getTypeName()) || varDecl.getType() != null && varDecl.getType().getTypeEntry() != null && this.compareStrings(varDecl.getType().getTypeEntry().getFullTypeName());
            }
            if ((modelElement instanceof Algorithm || modelElement instanceof Method) && this.matchInST(modelElement)) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean matchInST(INamedElement modelElement) {
        String text = ModelSearchQuery.getImplText(modelElement);
        if (text != null) {
            if (!this.pattern.preScanST(text)) return false;
        }
        try {
            String fqn;
            Iterator iterator = VariableOperations.getAllDependencies((EObject)modelElement).iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!this.compareStrings(fqn = (String)iterator.next()));
            return true;
        }
        catch (EvaluatorPrepareException e) {
            this.isIncompleteResult = true;
        }
        return false;
    }

    private static String getImplText(INamedElement modelElement) {
        if (modelElement instanceof TextAlgorithm) {
            TextAlgorithm textAlg = (TextAlgorithm)modelElement;
            return textAlg.getText();
        }
        if (modelElement instanceof TextMethod) {
            TextMethod textMethod = (TextMethod)modelElement;
            return textMethod.getText();
        }
        return null;
    }

    private boolean compareStrings(String toTest) {
        if (toTest == null) {
            return false;
        }
        if (this.pattern.matchSearchString(toTest)) {
            return true;
        }
        if (this.modelQuerySpec.checkExactMatching()) {
            return toTest.equals(this.modelQuerySpec.searchString());
        }
        if (this.modelQuerySpec.checkCaseSensitive()) {
            return toTest.contains(this.modelQuerySpec.searchString());
        }
        return toTest.toLowerCase().contains(this.modelQuerySpec.searchString().toLowerCase());
    }

    public String getLabel() {
        return this.modelQuerySpec.searchString();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ModelSearchResult getSearchResult() {
        if (this.searchResult == null) {
            this.searchResult = this.createModelSearchResult();
        }
        return this.searchResult;
    }

    protected ModelSearchResult createModelSearchResult() {
        return new ModelSearchResult(this);
    }

    private static class SearchCanceledException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private SearchCanceledException() {
        }

        public static void throwIfCanceled(IProgressMonitor monitor) {
            if (monitor != null && monitor.isCanceled()) {
                throw new SearchCanceledException();
            }
        }
    }
}

