/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.helpers;

import java.util.function.Predicate;
import java.util.stream.DoubleStream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.HiddenElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;

public final class FBShapeHelper {
    private static final String DIAGRAM_PREFERENCE_QUALIFIER = "org.eclipse.fordiac.ide.gef";
    private static int minPinLabelSize = Platform.getPreferencesService().getInt("org.eclipse.fordiac.ide.gef", "MinPinLabelSize", 0, null);
    private static int maxPinLabelSize = Platform.getPreferencesService().getInt("org.eclipse.fordiac.ide.gef", "MaxPinLabelSize", 60, null);
    private static int maxTypeLabelSize = Platform.getPreferencesService().getInt("org.eclipse.fordiac.ide.gef", "MaxTypeLabelSize", 120, null);
    private static final int MAX_INTERFACE_BAR_SIZE = Platform.getPreferencesService().getInt("org.eclipse.fordiac.ide.gef", "MaxInterfaceBarSize", 0, null);
    private static double maxInterfaceBarWidth = -1.0;
    public static final double IEC61499_LINE_HEIGHT = 100.0;
    private static final double AVARAGE_CHAR_WIDTH = CoordinateConverter.INSTANCE.screenToIEC61499((int)CoordinateConverter.INSTANCE.getAverageCharacterWidth());
    private static final double WIDTH_ADJUST_NAME = CoordinateConverter.INSTANCE.screenToIEC61499(5);
    private static final double WIDTH_ADJUST_TYPE_NAME = CoordinateConverter.INSTANCE.screenToIEC61499(47);
    private static final double WIDTH_ADJUST_STRUCT_NAME = CoordinateConverter.INSTANCE.screenToIEC61499(48);
    private static final double WIDTH_ADJUST_INTERFACE = CoordinateConverter.INSTANCE.screenToIEC61499(24);
    private static final double HEIGHT_ADJUST_HIDDEN = CoordinateConverter.INSTANCE.screenToIEC61499(15);

    public static double getWidth(FBNetworkElement element) {
        double nameWidth = (double)element.getName().length() * AVARAGE_CHAR_WIDTH + WIDTH_ADJUST_NAME;
        double typeNameWidth = (double)FBShapeHelper.getTypeNameCharacters(element) * AVARAGE_CHAR_WIDTH + WIDTH_ADJUST_TYPE_NAME;
        double structNameWidth = (double)FBShapeHelper.getStructNameCharacters(element) * AVARAGE_CHAR_WIDTH + WIDTH_ADJUST_STRUCT_NAME;
        int inputCharacters = FBShapeHelper.getInterfaceCharacters(element, IInterfaceElement::isIsInput);
        int outputCharacters = FBShapeHelper.getInterfaceCharacters(element, Predicate.not(IInterfaceElement::isIsInput));
        double interfaceWidth = (double)(inputCharacters + outputCharacters) * AVARAGE_CHAR_WIDTH + WIDTH_ADJUST_INTERFACE;
        return DoubleStream.of(nameWidth, typeNameWidth, structNameWidth, interfaceWidth).max().orElse(0.0);
    }

    public static double getHeight(FBNetworkElement element) {
        int fbLines = element instanceof StructManipulator ? 3 : 2;
        int inputLines = FBShapeHelper.getInterfaceLines(element, IInterfaceElement::isIsInput);
        int outputLines = FBShapeHelper.getInterfaceLines(element, Predicate.not(IInterfaceElement::isIsInput));
        int lines = fbLines + Math.max(inputLines, outputLines);
        return (double)lines * 100.0 + FBShapeHelper.getHeightAdjust(element);
    }

    public static double getMaxInterfaceBarWidth() {
        if (maxInterfaceBarWidth == -1.0) {
            maxInterfaceBarWidth = AVARAGE_CHAR_WIDTH * (double)MAX_INTERFACE_BAR_SIZE + 2.0 + WIDTH_ADJUST_INTERFACE;
        }
        return maxInterfaceBarWidth;
    }

    private static int getInterfaceLines(FBNetworkElement element, Predicate<IInterfaceElement> filter) {
        return (int)element.getInterface().getAllInterfaceElements().stream().filter(HiddenElement::isVisible).filter(filter).count();
    }

    private static int getInterfaceCharacters(FBNetworkElement element, Predicate<IInterfaceElement> filter) {
        int pinLabelSize = element.getInterface().getAllInterfaceElements().stream().filter(HiddenElement::isVisible).filter(filter).map(INamedElement::getName).mapToInt(String::length).max().orElse(0);
        return Math.clamp((long)pinLabelSize, minPinLabelSize, maxPinLabelSize + 1);
    }

    private static int getTypeNameCharacters(FBNetworkElement element) {
        return element.getTypeName() != null ? Math.min(element.getTypeName().length(), maxTypeLabelSize + 1) : 0;
    }

    private static int getStructNameCharacters(FBNetworkElement element) {
        StructManipulator structManipulator;
        if (element instanceof StructManipulator && (structManipulator = (StructManipulator)element).getDataType() != null) {
            return structManipulator.getDataType().getName().length();
        }
        return 0;
    }

    protected static double getHeightAdjust(FBNetworkElement element) {
        if (element.getInterface().getAllInterfaceElements().stream().anyMatch(Predicate.not(HiddenElement::isVisible))) {
            return HEIGHT_ADJUST_HIDDEN;
        }
        return 0.0;
    }

    private FBShapeHelper() {
        throw new UnsupportedOperationException();
    }
}

