/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.policies;

import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.systemconfiguration.commands.LinkCreateCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class SegmentNodeEditPolicy
extends GraphicalNodeEditPolicy {
    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        if (request.getStartCommand() instanceof LinkCreateCommand) {
            LinkCreateCommand command = (LinkCreateCommand)request.getStartCommand();
            if (command.isSegmentDeviceLink()) {
                if (this.getHost().getModel() instanceof Device) {
                    command.setDestination((Device)this.getHost().getModel());
                } else if (this.getHost().getModel() instanceof Segment) {
                    command.setDestination(null);
                }
            } else if (this.getHost().getModel() instanceof Segment) {
                command.setSource((Segment)this.getHost().getModel());
            } else if (this.getHost().getModel() instanceof Device) {
                command.setSource(null);
            }
            return command;
        }
        return null;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        LinkCreateCommand cmd = new LinkCreateCommand();
        if (this.getHost().getModel() instanceof Segment) {
            cmd.setSource((Segment)this.getHost().getModel());
            cmd.setSegmentDeviceLink(true);
        } else if (this.getHost().getModel() instanceof Device) {
            cmd.setDestination((Device)this.getHost().getModel());
        }
        Object parentModel = this.getHost().getParent().getModel();
        if (parentModel instanceof SystemConfiguration) {
            cmd.setSystemConfigurationNetwork((SystemConfiguration)parentModel);
        }
        request.setStartCommand((Command)cmd);
        return cmd;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        return null;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        return null;
    }
}

