/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.validation;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

public class STCoreTypeUsageCollector {
    @Inject
    private IQualifiedNameProvider nameProvider;
    private final Set<QualifiedName> usedTypes = new HashSet<QualifiedName>();

    public Set<QualifiedName> collectUsedTypes(EObject object) {
        this.collectUsedTypesFrom(object);
        TreeIterator iter = EcoreUtil.getAllProperContents((EObject)object, (boolean)true);
        while (iter.hasNext()) {
            this.collectUsedTypesFrom((EObject)iter.next());
        }
        return this.usedTypes;
    }

    protected void collectUsedTypesFrom(EObject object) {
        object.eCrossReferences().stream().filter(target -> STCoreTypeUsageCollector.isExternalReference(object, target)).forEachOrdered(this::addUsedType);
    }

    protected static boolean isExternalReference(EObject source, EObject target) {
        return source.eResource() != target.eResource();
    }

    public void addUsedType(EObject object) {
        INamedElement importedType = STCoreTypeUsageCollector.resolveImportedType(object);
        if (importedType != null) {
            this.usedTypes.add((QualifiedName)this.nameProvider.apply((Object)importedType));
        }
    }

    protected static INamedElement resolveImportedType(EObject object) {
        if (object.eIsProxy()) {
            return null;
        }
        LibraryElement libraryElement = (LibraryElement)EcoreUtil2.getContainerOfType((EObject)object, LibraryElement.class);
        if (libraryElement != null) {
            return libraryElement;
        }
        if (object instanceof INamedElement) {
            INamedElement element = (INamedElement)object;
            return element;
        }
        return null;
    }

    public Set<QualifiedName> getUsedTypes() {
        return this.usedTypes;
    }
}

