/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui.editparts;

import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.deployment.debug.ui.annotation.WatchValueAnnotation;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.editparts.SpecificLayerEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public abstract class AbstractWatchValueEditPart
extends AbstractGraphicalEditPart
implements SpecificLayerEditPart {
    private final AncestorMoveListener hostMoveListener = new AncestorMoveListener();
    private InterfaceEditPart host;

    public void activate() {
        super.activate();
        this.refreshVisuals();
    }

    public void deactivate() {
        if (this.host != null) {
            this.host.getFigure().removeAncestorListener((AncestorListener)this.hostMoveListener);
        }
        super.deactivate();
    }

    public IInterfaceElement getInterfaceElement() {
        return this.getModel().getElement();
    }

    public WatchValueAnnotation getModel() {
        return (WatchValueAnnotation)((Object)super.getModel());
    }

    public InterfaceEditPart getHost() {
        Object v;
        if (this.host == null && (v = this.getViewer().getEditPartRegistry().get(this.getInterfaceElement())) instanceof InterfaceEditPart) {
            InterfaceEditPart iep;
            this.host = iep = (InterfaceEditPart)v;
            this.host.getFigure().addAncestorListener((AncestorListener)this.hostMoveListener);
        }
        return this.host;
    }

    public String getSpecificLayer() {
        return "TOPLAYER";
    }

    public boolean understandsRequest(Request request) {
        if (request.getType() == "move") {
            return false;
        }
        return super.understandsRequest(request);
    }

    public void removeNotify() {
        IFigure layerFig;
        if (this.isGrandParentDeletion() && (layerFig = this.getLayer(this.getSpecificLayer())) != null && layerFig.equals(this.getFigure().getParent())) {
            layerFig.remove(this.getFigure());
            return;
        }
        super.removeNotify();
    }

    private boolean isGrandParentDeletion() {
        return this.getInterfaceElement().getFBNetworkElement() != null && this.getInterfaceElement().getFBNetworkElement().getFbNetwork() != null;
    }

    protected Point calculatePos() {
        if (this.getHost() != null) {
            Rectangle bounds = this.getHost().getFigure().getBounds();
            int x = 0;
            if (this.getInterfaceElement().isIsInput()) {
                int width = this.calculateSize().width;
                x = bounds.x - 2 - width;
            } else {
                x = bounds.x + bounds.width + 2;
            }
            int y = bounds.y;
            return new Point(x, y);
        }
        return new Point(0, 0);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshPosition();
    }

    protected void refreshPosition() {
        if (this.getParent() != null) {
            Rectangle bounds = null;
            Point p = this.calculatePos();
            Dimension dimension = this.calculateSize();
            bounds = new Rectangle(p.x, p.y, dimension.width, dimension.height);
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds);
        }
    }

    protected abstract Dimension calculateSize();

    public <T> T getAdapter(Class<T> key) {
        if (key == IInterfaceElement.class) {
            return key.cast(this.getInterfaceElement());
        }
        return (T)super.getAdapter(key);
    }

    protected class AncestorMoveListener
    implements AncestorListener {
        protected AncestorMoveListener() {
        }

        public void ancestorRemoved(IFigure ancestor) {
        }

        public void ancestorMoved(IFigure ancestor) {
            AbstractWatchValueEditPart.this.refreshVisuals();
        }

        public void ancestorAdded(IFigure ancestor) {
        }
    }
}

