/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui.handler;

import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.deployment.debug.breakpoint.DeploymentWatchpoint;
import org.eclipse.fordiac.ide.deployment.debug.ui.Messages;
import org.eclipse.fordiac.ide.deployment.debug.ui.breakpoint.DeploymentWatchpointUtil;
import org.eclipse.fordiac.ide.deployment.debug.ui.handler.DeploymentHandlerUtil;
import org.eclipse.fordiac.ide.gef.dialogs.VariableDialog;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.edit.helper.InitialValueHelper;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ForceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        VarDeclaration varDeclaration;
        EObject eObject;
        IInterfaceElement iInterfaceElement = DeploymentHandlerUtil.getInterfaceElement(event);
        if (iInterfaceElement instanceof VarDeclaration && (eObject = EcoreUtil.getRootContainer((EObject)(varDeclaration = (VarDeclaration)iInterfaceElement))) instanceof AutomationSystem) {
            AutomationSystem system = (AutomationSystem)eObject;
            IFile file = system.getTypeEntry().getFile();
            Optional<String> newValue = ForceHandler.openForceDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), varDeclaration);
            if (newValue.isPresent()) {
                Optional<DeploymentWatchpoint> watchpoint = DeploymentWatchpointUtil.findExistingWatchpoint((IResource)file, (INamedElement)varDeclaration);
                if (watchpoint.isEmpty()) {
                    ForceHandler.createWatchpoint((IResource)file, varDeclaration, newValue.get(), event);
                } else {
                    ForceHandler.updateWatchpoint(watchpoint.get(), newValue.get(), event);
                }
            }
        }
        return null;
    }

    private static void createWatchpoint(IResource resource, VarDeclaration varDeclaration, String newValue, ExecutionEvent event) {
        if (newValue.isBlank()) {
            return;
        }
        try {
            DeploymentWatchpoint watchpoint = new DeploymentWatchpoint(resource, (INamedElement)varDeclaration);
            watchpoint.setForceValue(newValue);
            watchpoint.setForceEnabled(true);
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)watchpoint);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), null, null, (IStatus)e.getStatus());
        }
    }

    private static void updateWatchpoint(DeploymentWatchpoint watchpoint, String newValue, ExecutionEvent event) {
        try {
            watchpoint.setForceValue(newValue);
            watchpoint.setForceEnabled(!newValue.isBlank());
            watchpoint.setEnabled(true);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), null, null, (IStatus)e.getStatus());
        }
    }

    private static Optional<String> openForceDialog(Shell shell, VarDeclaration varDeclaration) {
        String initialValue = InitialValueHelper.getInitialOrDefaultValue((Object)varDeclaration);
        if (varDeclaration.getType() instanceof StructuredType || varDeclaration.isArray()) {
            return VariableDialog.open((Shell)shell, (String)Messages.ForceHandler_ForceDialogTitle, (ITypedElement)varDeclaration, (String)initialValue);
        }
        InputDialog dialog = new InputDialog(shell, Messages.ForceHandler_ForceDialogTitle, Messages.ForceHandler_ForceDialogInput, initialValue, newValue -> ForceHandler.validateValue(varDeclaration, newValue));
        if (dialog.open() == 0) {
            return Optional.of(dialog.getValue());
        }
        return Optional.empty();
    }

    private static String validateValue(VarDeclaration varDeclaration, String newValue) {
        String error = VariableOperations.validateValue((VarDeclaration)varDeclaration, (String)newValue);
        if (error.isBlank()) {
            return null;
        }
        return error;
    }
}

