/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.utility.MapIterate;

public final class ReflectionHelper {
    @Deprecated
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final ImmutableMap<Class<?>, Class<?>> WRAPPER_TO_PRIMATIVES = UnifiedMap.newMapWith(new Pair[]{Tuples.twin(Short.class, Short.TYPE), Tuples.twin(Boolean.class, Boolean.TYPE), Tuples.twin(Byte.class, Byte.TYPE), Tuples.twin(Character.class, Character.TYPE), Tuples.twin(Integer.class, Integer.TYPE), Tuples.twin(Float.class, Float.TYPE), Tuples.twin(Long.class, Long.TYPE), Tuples.twin(Double.class, Double.TYPE)}).toImmutable();
    private static final ImmutableMap<Class<?>, Class<?>> PRIMATIVES_TO_WRAPPERS = MapIterate.reverseMapping(WRAPPER_TO_PRIMATIVES.castToMap()).toImmutable();

    private ReflectionHelper() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> Constructor<T> getConstructor(Class<T> instantiable, Class<?> ... constructorParameterTypes) {
        try {
            return instantiable.getConstructor(constructorParameterTypes);
        }
        catch (NoSuchMethodException ignored) {
            return ReflectionHelper.searchForConstructor(instantiable, constructorParameterTypes);
        }
    }

    private static <T> Constructor<T> searchForConstructor(Class<T> instantiable, Class<?> ... constructorParameterTypes) {
        Constructor<?>[] candidates;
        for (Constructor<?> candidate : candidates = instantiable.getConstructors()) {
            if (!ReflectionHelper.parameterTypesMatch(candidate.getParameterTypes(), constructorParameterTypes)) continue;
            return candidate;
        }
        return null;
    }

    public static boolean parameterTypesMatch(Class<?>[] candidateParamTypes, Class<?> ... desiredParameterTypes) {
        boolean match = candidateParamTypes.length == desiredParameterTypes.length;
        for (int i = 0; i < candidateParamTypes.length && match; ++i) {
            Class candidateType = candidateParamTypes[i].isPrimitive() && !desiredParameterTypes[i].isPrimitive() ? (Class)PRIMATIVES_TO_WRAPPERS.get(candidateParamTypes[i]) : candidateParamTypes[i];
            match = candidateType.isAssignableFrom(desiredParameterTypes[i]);
        }
        return match;
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... constructorArguments) {
        try {
            return constructor.newInstance(constructorArguments);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> aClass) {
        try {
            return aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasDefaultConstructor(Class<?> aClass) {
        try {
            Constructor<?> constructor = aClass.getDeclaredConstructor(EMPTY_CLASS_ARRAY);
            return Modifier.isPublic(constructor.getModifiers());
        }
        catch (NoSuchMethodException ignored) {
            return false;
        }
    }
}

