/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parsetree.reconstr.impl.NodeIterator;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public final class STCoreRefactoringUtil {
    public static EObject findSelectedSemanticObject(XtextResource resource, ITextSelection selection) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null) {
            EObject rootSemanticObject = parseResult.getRootASTElement();
            TreeIterator iterator = EcoreUtil.getAllProperContents((EObject)rootSemanticObject, (boolean)true);
            EObject result = null;
            while (iterator.hasNext()) {
                EObject semanticObject = (EObject)iterator.next();
                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)semanticObject);
                if (node == null) continue;
                ITextRegion nodeRegion = STCoreRefactoringUtil.getExtendedTotalTextRegion((INode)node);
                if (!STCoreRefactoringUtil.intersects(nodeRegion, selection)) {
                    iterator.prune();
                    continue;
                }
                if (!STCoreRefactoringUtil.contains(nodeRegion, selection)) continue;
                result = semanticObject;
            }
            return result;
        }
        return null;
    }

    public static List<EObject> findSelectedChildSemanticObjects(EObject container, ITextSelection selection) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        ITextRegion commonRegion = null;
        for (EObject semanticObject : container.eContents()) {
            ITextRegion nodeRegion;
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)semanticObject);
            if (node == null || !STCoreRefactoringUtil.intersects(nodeRegion = STCoreRefactoringUtil.getExtendedTotalTextRegion((INode)node), selection)) continue;
            commonRegion = commonRegion == null ? nodeRegion : commonRegion.merge(nodeRegion);
            result.add(semanticObject);
        }
        if (commonRegion != null && STCoreRefactoringUtil.contains(commonRegion, selection)) {
            return result;
        }
        return List.of(container);
    }

    public static <T extends EObject> List<T> findSelectedChildSemanticObjectsOfType(EObject container, ITextSelection selection, Class<? extends T> filter) {
        List<EObject> childSemanticObjects = STCoreRefactoringUtil.findSelectedChildSemanticObjects(container, selection);
        if (childSemanticObjects.stream().allMatch(filter::isInstance)) {
            return childSemanticObjects.stream().map(filter::cast).collect(Collectors.toList());
        }
        if (filter.isInstance(container)) {
            return List.of((EObject)filter.cast(container));
        }
        return Collections.emptyList();
    }

    public static ITextRegion getExtendedTotalTextRegion(INode node) {
        ITextRegion result = node.getTotalTextRegion();
        NodeIterator iterator = new NodeIterator(node);
        iterator.prune();
        while (iterator.hasNext()) {
            INode next = iterator.next();
            if (!(next instanceof ILeafNode)) continue;
            ILeafNode nextLeaf = (ILeafNode)next;
            if (!nextLeaf.isHidden()) break;
            result = result.merge(next.getTextRegion());
        }
        return result;
    }

    public static ITextSelection trimSelection(ITextSelection selection) {
        String selectionText = selection.getText();
        int offset = 0;
        int length = selection.getLength();
        while (offset < length && Character.isWhitespace(selectionText.charAt(offset))) {
            ++offset;
        }
        while (length > offset && Character.isWhitespace(selectionText.charAt(length - 1))) {
            --length;
        }
        return new TextSelection(selection.getOffset() + offset, length - offset);
    }

    public static ITextRegion trimRegion(ITextRegion region, ICompositeNode rootNode) {
        String selectionText = rootNode.getText().substring(region.getOffset(), region.getOffset() + region.getLength());
        int offset = 0;
        int length = region.getLength();
        while (offset < length && Character.isWhitespace(selectionText.charAt(offset))) {
            ++offset;
        }
        while (length > offset && Character.isWhitespace(selectionText.charAt(length - 1))) {
            --length;
        }
        return new TextRegion(region.getOffset() + offset, length - offset);
    }

    public static ITextRegion alignRegion(ITextRegion region, ICompositeNode rootNode) {
        ILeafNode firstLeafNode = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)region.getOffset());
        ILeafNode lastLeafNode = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)(region.getOffset() + (region.getLength() > 0 ? region.getLength() - 1 : 0)));
        return new TextRegion(firstLeafNode.getOffset(), lastLeafNode.getEndOffset() - firstLeafNode.getOffset());
    }

    private static boolean contains(ITextRegion region, ITextSelection selection) {
        return region.getOffset() <= selection.getOffset() && region.getOffset() + region.getLength() >= selection.getOffset() + selection.getLength();
    }

    private static boolean intersects(ITextRegion region, ITextSelection selection) {
        return region.getOffset() < selection.getOffset() + selection.getLength() && region.getOffset() + region.getLength() > selection.getOffset();
    }

    private STCoreRefactoringUtil() {
        throw new UnsupportedOperationException();
    }
}

