/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DifferenceGroupProviderChange;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.EmptyDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

public final class StructureMergeViewerGrouper {
    private final IDifferenceGroupProvider empty = new EmptyDifferenceGroupProvider();
    private IDifferenceGroupProvider provider;
    private final List<StructuredViewer> viewers;
    private final EventBus eventBus;
    private final Set<IDifferenceGroupProvider> registeredGroupProviders;

    public StructureMergeViewerGrouper(EventBus eventBus) {
        this.eventBus = eventBus;
        this.provider = this.empty;
        this.viewers = Lists.newArrayList();
        this.registeredGroupProviders = Sets.newLinkedHashSet();
    }

    public void setProvider(IDifferenceGroupProvider provider) {
        if (this.provider != provider) {
            this.provider = provider;
            this.refreshViewers();
            this.eventBus.post((Object)new DifferenceGroupProviderChange(provider));
        }
    }

    public IDifferenceGroupProvider getProvider() {
        return this.provider;
    }

    private void refreshViewers() {
        for (StructuredViewer viewer : this.viewers) {
            Adapter root = (Adapter)viewer.getInput();
            if (root == null) continue;
            Notifier target = root.getTarget();
            this.registerDifferenceGroupProvider(target, this.provider);
        }
    }

    protected void registerDifferenceGroupProvider(Notifier notifier, IDifferenceGroupProvider groupProvider) {
        EList eAdapters = notifier.eAdapters();
        Adapter oldGroupProvider = EcoreUtil.getAdapter((List)eAdapters, IDifferenceGroupProvider.class);
        if (oldGroupProvider != null) {
            eAdapters.remove(oldGroupProvider);
        }
        eAdapters.add(groupProvider);
        this.registeredGroupProviders.add(groupProvider);
    }

    public void install(final StructuredViewer viewer) {
        viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StructureMergeViewerGrouper.this.uninstall(viewer);
            }
        });
        this.viewers.add(viewer);
    }

    public void uninstall(StructuredViewer viewer) {
        Object input = viewer.getInput();
        Object notifier = input instanceof Notifier ? (Notifier)input : (input instanceof Adapter ? ((Adapter)input).getTarget() : null);
        if (notifier != null) {
            EList eAdapters = notifier.eAdapters();
            Adapter groupProvider = EcoreUtil.getAdapter((List)eAdapters, IDifferenceGroupProvider.class);
            if (this.provider != groupProvider) {
                throw new IllegalStateException();
            }
            eAdapters.remove(this.provider);
        }
        for (IDifferenceGroupProvider registeredGroupProvider : this.registeredGroupProviders) {
            registeredGroupProvider.dispose();
        }
        this.viewers.remove(viewer);
    }
}

