/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.service;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.acceleo.common.interpreter.CompilationResult;
import org.eclipse.acceleo.common.interpreter.EvaluationResult;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.generation.AcceleoEngine;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.generation.strategy.PreviewStrategy;
import org.eclipse.acceleo.engine.service.AcceleoModulePropertiesAdapter;
import org.eclipse.acceleo.engine.service.EvaluationContext;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.Bag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEvaluationTask
implements Callable<EvaluationResult> {
    private EvaluationContext context;

    public AcceleoEvaluationTask(EvaluationContext context) {
        this.context = context;
    }

    private static Object evaluateQuery(EvaluationContext context) {
        Query query = (Query)context.getCompilationResult().getCompiledExpression();
        EList parameters = query.getParameter();
        ArrayList arguments = Lists.newArrayList((Object[])new Object[]{context.getTargetEObject()});
        Iterator paramIterator = parameters.iterator();
        if (paramIterator.hasNext()) {
            paramIterator.next();
        }
        while (paramIterator.hasNext()) {
            Variable parameter = (Variable)paramIterator.next();
            boolean foundMatch = false;
            Iterator variableIterator = context.getVariables().asMap().entrySet().iterator();
            while (!foundMatch && variableIterator.hasNext()) {
                Map.Entry variable = variableIterator.next();
                if (!((String)variable.getKey()).equals(parameter.getName())) continue;
                List values = (List)variable.getValue();
                arguments.add(values.listIterator(values.size()).previous());
                foundMatch = true;
            }
            if (foundMatch) continue;
            arguments.add(null);
        }
        AcceleoEngine engine = new AcceleoEngine();
        PreviewStrategy strategy = new PreviewStrategy();
        Object result = engine.evaluate(query, (List<? extends Object>)arguments, (IAcceleoGenerationStrategy)strategy, (Monitor)new BasicMonitor());
        return result;
    }

    private static EClassifier getOCLType(EcoreEnvironment env, Object obj) {
        OCLStandardLibrary library = env.getOCLStandardLibrary();
        EClassifier oclType = (EClassifier)library.getOclAny();
        if (obj instanceof Number) {
            oclType = obj instanceof BigDecimal || obj instanceof Double || obj instanceof Float ? (EClassifier)library.getReal() : (EClassifier)library.getInteger();
        } else if (obj instanceof String) {
            oclType = (EClassifier)library.getString();
        } else if (obj instanceof Boolean) {
            oclType = (EClassifier)library.getBoolean();
        } else if (obj instanceof EObject) {
            oclType = (EClassifier)env.getUMLReflection().asOCLType((Object)((EObject)obj).eClass());
        } else if (obj instanceof Collection) {
            oclType = obj instanceof LinkedHashSet ? (EClassifier)library.getOrderedSet() : (obj instanceof Set ? (EClassifier)library.getSet() : (obj instanceof Bag ? (EClassifier)library.getBag() : (EClassifier)library.getSequence()));
        }
        return oclType;
    }

    private static EClassifier inferCollectionContentOCLType(EcoreEnvironment env, Collection<?> coll) {
        if (coll.isEmpty()) {
            return (EClassifier)env.getOCLStandardLibrary().getOclAny();
        }
        HashSet<EClassifier> types = new HashSet<EClassifier>();
        for (Object child : coll) {
            types.add(AcceleoEvaluationTask.getOCLType(env, child));
        }
        Iterator iterator = types.iterator();
        EClassifier elementType = (EClassifier)iterator.next();
        while (iterator.hasNext()) {
            elementType = (EClassifier)env.getUMLReflection().getCommonSuperType((Object)elementType, (Object)((EClassifier)iterator.next()));
        }
        if (elementType == null) {
            elementType = (EClassifier)env.getOCLStandardLibrary().getOclAny();
        }
        return elementType;
    }

    private static String inferOCLType(Object obj) {
        String oclType = "OCLAny";
        EcoreEnvironment env = (EcoreEnvironment)new EcoreEnvironmentFactory().createEnvironment();
        if (obj instanceof Collection) {
            EClassifier elementType = AcceleoEvaluationTask.inferCollectionContentOCLType(env, (Collection)obj);
            CollectionKind kind = CollectionKind.SEQUENCE_LITERAL;
            if (obj instanceof LinkedHashSet) {
                kind = CollectionKind.ORDERED_SET_LITERAL;
            } else if (obj instanceof Set) {
                kind = CollectionKind.SET_LITERAL;
            } else if (obj instanceof Bag) {
                kind = CollectionKind.BAG_LITERAL;
            }
            oclType = env.getTypeResolver().resolveCollectionType(kind, (Object)elementType).getName();
        } else {
            oclType = AcceleoEvaluationTask.getOCLType(env, obj).getName();
        }
        return oclType;
    }

    @Override
    public EvaluationResult call() throws Exception {
        CompilationResult compilationResult = this.context.getCompilationResult();
        EvaluationResult shortcutResult = null;
        if (compilationResult == null || !(compilationResult.getCompiledExpression() instanceof Query)) {
            shortcutResult = new EvaluationResult((IStatus)new Status(4, "org.eclipse.acceleo.engine", AcceleoEngineMessages.getString("AcceleoEvaluationTask.UnresolvedCompilationProblem")));
        } else if (compilationResult.getStatus() != null && compilationResult.getStatus().getSeverity() == 4) {
            shortcutResult = new EvaluationResult(null);
        }
        if (shortcutResult != null) {
            return shortcutResult;
        }
        assert (compilationResult != null);
        Object compiledExpression = compilationResult.getCompiledExpression();
        if (compiledExpression instanceof EObject) {
            Module module = null;
            EObject eObject = (EObject)compiledExpression;
            if (eObject instanceof Module) {
                module = (Module)eObject;
            } else {
                EObject parent = eObject.eContainer();
                while (parent != null && !(parent instanceof Module)) {
                    parent = parent.eContainer();
                }
                if (parent instanceof Module) {
                    module = (Module)parent;
                }
            }
            if (module != null) {
                AcceleoModulePropertiesAdapter adapter = new AcceleoModulePropertiesAdapter();
                adapter.addProperty("DISABLE_DYNAMIC_MODULES");
                module.eAdapters().add((Object)adapter);
            }
        }
        boolean notificationsState = false;
        boolean debugMessagesState = false;
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            notificationsState = AcceleoPreferences.areNotificationsEnabled();
            AcceleoPreferences.switchNotifications((boolean)false);
            debugMessagesState = AcceleoPreferences.isDebugMessagesEnabled();
            AcceleoPreferences.switchDebugMessages((boolean)false);
        }
        EvaluationLogListener evaluationListener = new EvaluationLogListener();
        if (Platform.isRunning()) {
            Platform.addLogListener((ILogListener)evaluationListener);
        }
        try {
            Object result = AcceleoEvaluationTask.evaluateQuery(this.context);
            IStatus resultStatus = this.createResultStatus(result);
            IStatus accumulatedProblems = evaluationListener.getAccumulatedProblems();
            if (accumulatedProblems instanceof MultiStatus && accumulatedProblems.getSeverity() != 4) {
                ((MultiStatus)accumulatedProblems).add(resultStatus);
            } else if (accumulatedProblems != null && accumulatedProblems.getSeverity() != 4) {
                accumulatedProblems = new MultiStatus("org.eclipse.acceleo.engine", 1, new IStatus[]{accumulatedProblems, resultStatus}, AcceleoEngineMessages.getString("AcceleoEvaluationTask.MultipleProblems"), null);
            } else if (accumulatedProblems == null) {
                accumulatedProblems = resultStatus;
            }
            EvaluationResult evaluationResult = new EvaluationResult(result, accumulatedProblems);
            return evaluationResult;
        }
        finally {
            if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                AcceleoPreferences.switchNotifications((boolean)notificationsState);
                AcceleoPreferences.switchDebugMessages((boolean)debugMessagesState);
            }
            if (Platform.isRunning()) {
                Platform.removeLogListener((ILogListener)evaluationListener);
            }
        }
    }

    private IStatus createResultStatus(Object result) {
        String oclType = result == null ? "OCLVoid" : AcceleoEvaluationTask.inferOCLType(result);
        String size = null;
        if (result instanceof String) {
            size = String.valueOf(((String)result).length());
        } else if (result instanceof Collection) {
            size = String.valueOf(((Collection)result).size());
        }
        String message = AcceleoEngineMessages.getString("AcceleoEvaluationTask.ResultType", oclType);
        if (size != null) {
            message = String.valueOf(message) + ' ' + AcceleoEngineMessages.getString("AcceleoEvaluationTask.ResultSize", size);
        }
        return new Status(0, "org.eclipse.acceleo.engine", message);
    }

    protected static final class EvaluationLogListener
    implements ILogListener {
        private IStatus evaluationStatus;

        protected EvaluationLogListener() {
        }

        public IStatus getAccumulatedProblems() {
            return this.evaluationStatus;
        }

        public void logging(IStatus status, String plugin) {
            if (status.getPlugin().startsWith("org.eclipse.acceleo") || status.getPlugin().startsWith("org.eclipse.ocl") || "org.eclipse.acceleo.engine".equals(status.getPlugin())) {
                this.addStatus(status);
            }
        }

        private void addStatus(IStatus status) {
            if (this.evaluationStatus == null) {
                this.evaluationStatus = status;
            } else if (this.evaluationStatus instanceof MultiStatus) {
                ((MultiStatus)this.evaluationStatus).add(status);
            } else {
                this.evaluationStatus = new MultiStatus("org.eclipse.acceleo.engine", 1, new IStatus[]{this.evaluationStatus}, AcceleoEngineMessages.getString("AcceleoEvaluationTask.MultipleProblems"), null);
            }
        }
    }
}

