/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.service.properties;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.service.AcceleoService;
import org.eclipse.acceleo.engine.service.properties.AbstractAcceleoPropertiesLoaderService;
import org.eclipse.emf.common.EMFPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class BundleAcceleoPropertiesLoaderService
extends AbstractAcceleoPropertiesLoaderService {
    public static final String PLATFORM_PLUGIN = "platform:/plugin/";
    protected static final String PROPERTIES_FILES_EXTENSION = ".properties";
    private Bundle bundle;

    public BundleAcceleoPropertiesLoaderService(AcceleoService acceleoService, Bundle bundle) {
        this.acceleoService = acceleoService;
        this.bundle = bundle;
    }

    public BundleAcceleoPropertiesLoaderService(AcceleoService acceleoService, Bundle bundle, boolean forceProperties) {
        this.acceleoService = acceleoService;
        this.bundle = bundle;
        this.forceProperties = forceProperties;
    }

    protected Properties alternatePropertiesLoading(String filepath) {
        Properties properties = new Properties();
        if (EMFPlugin.IS_ECLIPSE_RUNNING && this.bundle != null) {
            if (!filepath.startsWith(PLATFORM_PLUGIN)) {
                properties = this.loadPropertiesFromCurrentBundle(filepath);
                if (properties.isEmpty()) {
                    properties = this.loadProperties(filepath);
                }
            } else if (filepath.indexOf(47, PLATFORM_PLUGIN.length() + 1) != -1) {
                properties = this.loadPropertiesFromAnotherBundle(filepath);
            }
        }
        return properties;
    }

    protected Properties loadPropertiesFromCurrentBundle(String pathInBundle) {
        Properties properties = new Properties();
        try {
            URL resource = this.bundle.getResource(pathInBundle);
            if (resource != null) {
                properties.load(resource.openStream());
            } else if (pathInBundle != null) {
                String filename = pathInBundle;
                if (!filename.endsWith(PROPERTIES_FILES_EXTENSION) && filename.contains(".")) {
                    filename = filename.substring(filename.lastIndexOf(".") + 1);
                    filename = String.valueOf(filename) + PROPERTIES_FILES_EXTENSION;
                }
                Enumeration entries = this.bundle.findEntries("/", filename, true);
                Object firstEntry = null;
                if (entries != null && entries.hasMoreElements()) {
                    firstEntry = entries.nextElement();
                }
                if (firstEntry instanceof URL) {
                    properties.load(((URL)firstEntry).openStream());
                }
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return properties;
    }

    protected Properties loadPropertiesFromAnotherBundle(String pathInBundle) {
        Properties properties = new Properties();
        String bundleName = pathInBundle.substring(PLATFORM_PLUGIN.length());
        bundleName = bundleName.substring(0, bundleName.indexOf(47));
        String resourcePath = pathInBundle.substring(PLATFORM_PLUGIN.length());
        resourcePath = resourcePath.substring(resourcePath.indexOf(47));
        Bundle[] bundles = null;
        BundleContext context = AcceleoEnginePlugin.getDefault().getBundle().getBundleContext();
        ServiceReference packageAdminReference = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminReference != null) {
            packageAdmin = (PackageAdmin)context.getService(packageAdminReference);
        }
        if (packageAdmin != null) {
            bundles = packageAdmin.getBundles(bundleName, null);
        }
        if (packageAdminReference != null) {
            context.ungetService(packageAdminReference);
        }
        if (bundles != null) {
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle resourceBundle = bundleArray[n2];
                URL resource = resourceBundle.getResource(resourcePath);
                if (resource != null) {
                    try {
                        properties.load(resource.openStream());
                    }
                    catch (IOException e) {
                        AcceleoEnginePlugin.log(e, true);
                    }
                }
                if (!properties.isEmpty()) break;
                ++n2;
            }
        }
        return properties;
    }

    protected PropertyResourceBundle alternatePropertiesResourceBundleLoading(String filepath) {
        PropertyResourceBundle properties = null;
        if (EMFPlugin.IS_ECLIPSE_RUNNING && this.bundle != null) {
            if (!filepath.startsWith(PLATFORM_PLUGIN)) {
                properties = this.loadPropertiesResourceBundleFromCurrentBundle(filepath);
                if (properties == null) {
                    properties = this.loadPropertiesResourceBundle(filepath);
                }
            } else if (filepath.indexOf(47, PLATFORM_PLUGIN.length() + 1) != -1) {
                properties = this.loadPropertiesResourceBundleFromAnotherBundle(filepath);
            }
        }
        return properties;
    }

    protected PropertyResourceBundle loadPropertiesResourceBundleFromAnotherBundle(String pathInBundle) {
        PropertyResourceBundle properties = null;
        String bundleName = pathInBundle.substring(PLATFORM_PLUGIN.length());
        bundleName = bundleName.substring(0, bundleName.indexOf(47));
        String resourcePath = pathInBundle.substring(PLATFORM_PLUGIN.length());
        resourcePath = resourcePath.substring(resourcePath.indexOf(47));
        Bundle[] bundles = null;
        BundleContext context = AcceleoEnginePlugin.getDefault().getBundle().getBundleContext();
        ServiceReference packageAdminReference = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminReference != null) {
            packageAdmin = (PackageAdmin)context.getService(packageAdminReference);
        }
        if (packageAdmin != null) {
            bundles = packageAdmin.getBundles(bundleName, null);
        }
        if (packageAdminReference != null) {
            context.ungetService(packageAdminReference);
        }
        if (bundles != null) {
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle resourceBundle = bundleArray[n2];
                URL resource = resourceBundle.getResource(resourcePath);
                if (resource != null) {
                    try {
                        properties = new PropertyResourceBundle(resource.openStream());
                    }
                    catch (IOException e) {
                        AcceleoEnginePlugin.log(e, true);
                    }
                }
                if (properties != null) break;
                ++n2;
            }
        }
        return properties;
    }

    protected PropertyResourceBundle loadPropertiesResourceBundleFromCurrentBundle(String pathInBundle) {
        PropertyResourceBundle properties = null;
        try {
            URL resource = this.bundle.getResource(pathInBundle);
            if (resource != null) {
                properties = new PropertyResourceBundle(resource.openStream());
            } else if (pathInBundle != null) {
                String filename = pathInBundle;
                if (!filename.endsWith(PROPERTIES_FILES_EXTENSION) && filename.contains(".")) {
                    filename = filename.substring(filename.lastIndexOf(".") + 1);
                    filename = String.valueOf(filename) + PROPERTIES_FILES_EXTENSION;
                }
                Enumeration entries = this.bundle.findEntries("/", filename, true);
                Object firstEntry = null;
                if (entries != null && entries.hasMoreElements()) {
                    firstEntry = entries.nextElement();
                }
                if (firstEntry instanceof URL) {
                    properties = new PropertyResourceBundle(((URL)firstEntry).openStream());
                }
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return properties;
    }
}

