/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.config;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.polarsys.capella.core.data.capellacore.CapellacoreFactory;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.SecurityNeeds;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.test.common.TransactionalEditingDomainHelper;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;

public abstract class CybersecurityConfigProject
extends EmptyProject {
    protected String[] threatKinds = new String[]{"Eavesdropping", "Denial of service", "Theft", "Data alteration", "Intrusion", "Tampering"};
    SecurityNeeds sn = null;

    protected void undoAllChanges() {
    }

    protected void addLiteralType(EnumerationPropertyType type, Project project, String literalName) {
        TransactionalEditingDomainHelper tedHelper = new TransactionalEditingDomainHelper(TransactionUtil.getEditingDomain((EObject)project));
        try {
            tedHelper.executeCommand(() -> type.getOwnedLiterals().add((Object)CapellacoreFactory.eINSTANCE.createEnumerationPropertyLiteral(literalName)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void removeLiteralType(EnumerationPropertyType type, Project project, int index) {
        TransactionalEditingDomainHelper tedHelper = new TransactionalEditingDomainHelper(TransactionUtil.getEditingDomain((EObject)project));
        try {
            tedHelper.executeCommand(() -> type.getOwnedLiterals().remove(index));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void removeAllLiteralTypes(EnumerationPropertyType type, Project project) {
        TransactionalEditingDomainHelper tedHelper = new TransactionalEditingDomainHelper(TransactionUtil.getEditingDomain((EObject)project));
        try {
            tedHelper.executeCommand(() -> type.getOwnedLiterals().clear());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void removePropertyType(EnumerationPropertyType type, Project project) {
        TransactionalEditingDomainHelper tedHelper = new TransactionalEditingDomainHelper(TransactionUtil.getEditingDomain((EObject)project));
        try {
            tedHelper.executeCommand(() -> project.getOwnedEnumerationPropertyTypes().remove((Object)type));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updateThreatKind(Threat threat, EnumerationPropertyLiteral literal, Project project) {
        TransactionalEditingDomainHelper tedHelper = new TransactionalEditingDomainHelper(TransactionUtil.getEditingDomain((EObject)project));
        try {
            tedHelper.executeCommand(() -> threat.setKind(literal));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updateConfidentialityValue(SecurityNeeds sn, EnumerationPropertyLiteral literal, Project project) {
        TransactionalEditingDomainHelper tedHelper = new TransactionalEditingDomainHelper(TransactionUtil.getEditingDomain((EObject)project));
        try {
            tedHelper.executeCommand(() -> sn.setConfidentialityValue(literal));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected SecurityNeeds createSecurityNeeds(Project project, PrimaryAsset primaryAsset) {
        TransactionalEditingDomainHelper tedHelper = new TransactionalEditingDomainHelper(TransactionUtil.getEditingDomain((EObject)project));
        try {
            tedHelper.executeCommand(() -> {
                this.sn = CybersecurityFactory.eINSTANCE.createSecurityNeeds();
                primaryAsset.getOwnedExtensions().add((Object)this.sn);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.sn;
    }
}

