/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.model.skeleton.CapellaModelSkeleton;
import org.polarsys.capella.cybersecurity.business.queries.ThreatSourceUse_Actors;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.ThreatSourceUse;
import org.polarsys.capella.cybersecurity.test.common.BasicDynamicModelTest;
import org.polarsys.capella.cybersecurity.ui.semantic.browser.ThreatSourceThatUse;

public class ThreatSourceUsed
extends BasicDynamicModelTest {
    SystemComponent saComponent1;
    SystemComponent saComponent2;
    SystemComponent saComponent3;
    SystemAnalysis sa;
    IProject capellaProject;

    @Override
    protected void initModel(CapellaModelSkeleton skeleton2) {
        this.saComponent1 = CtxFactory.eINSTANCE.createSystemComponent("Actor1");
        this.saComponent1.setActor(true);
        this.saComponent2 = CtxFactory.eINSTANCE.createSystemComponent("Actor 2");
        this.saComponent2.setActor(true);
        this.saComponent3 = CtxFactory.eINSTANCE.createSystemComponent("Actor 3");
        this.saComponent3.setActor(false);
        this.sa = skeleton2.getSystemAnalysis();
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                ThreatSourceUsed.this.sa.getOwnedSystemComponentPkg().getOwnedSystemComponents().add((Object)ThreatSourceUsed.this.saComponent1);
                ThreatSourceUsed.this.sa.getOwnedSystemComponentPkg().getOwnedSystemComponents().add((Object)ThreatSourceUsed.this.saComponent2);
                ThreatSourceUsed.this.sa.getOwnedSystemComponentPkg().getOwnedSystemComponents().add((Object)ThreatSourceUsed.this.saComponent3);
            }
        };
        TransactionHelper.getExecutionManager((EObject)this.project).execute((ICommand)cmd);
    }

    public void test() throws Exception {
        ThreatSourceUse_Actors query = new ThreatSourceUse_Actors();
        ThreatSourceThatUse query2 = new ThreatSourceThatUse();
        List elements = query.getAvailableElements((EObject)this.saComponent1);
        ArrayList<SystemComponent> expectedElements = new ArrayList<SystemComponent>();
        expectedElements.add(this.saComponent2);
        ThreatSourceUsed.assertTrue((boolean)elements.equals(expectedElements));
        final ThreatSourceUse tsu = CybersecurityFactory.eINSTANCE.createThreatSourceUse();
        tsu.setUsed((Component)this.saComponent2);
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                ThreatSourceUsed.this.saComponent1.getOwnedExtensions().add((Object)tsu);
            }
        };
        TransactionHelper.getExecutionManager((EObject)this.project).execute((ICommand)cmd);
        List usedActors = query.getCurrentElements((EObject)this.saComponent1, false);
        ArrayList<SystemComponent> expectedUsedActors = new ArrayList<SystemComponent>();
        expectedUsedActors.add(this.saComponent2);
        ThreatSourceUsed.assertTrue((boolean)usedActors.equals(expectedUsedActors));
        List usedBy = query2.compute((Object)this.saComponent2);
        ArrayList<SystemComponent> expectedUsedBy = new ArrayList<SystemComponent>();
        expectedUsedBy.add(this.saComponent1);
        ThreatSourceUsed.assertTrue((boolean)usedBy.equals(expectedUsedBy));
        ThreatSourceUsed.assertTrue((query.getAvailableElements((EObject)this.saComponent1).size() == 0 ? 1 : 0) != 0);
    }
}

