/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.rules.testcases.cy_dcon;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.skeleton.CapellaModelSkeleton;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.ThreatSourceUse;
import org.polarsys.capella.cybersecurity.model.TrustBoundaryStorage;
import org.polarsys.capella.cybersecurity.sirius.analysis.CybersecurityServices;
import org.polarsys.capella.cybersecurity.test.common.DynamicValidationTest;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;

public class Rule_CY_DCON_04
extends DynamicValidationTest {
    private static final String RULE = "org.polarsys.capella.cybersecurity.validation.CY_DCON_04";
    protected XABDiagram diagram;
    CybersecurityServices service = new CybersecurityServices();
    ThreatSourceUse threatSourceUse;
    TrustBoundaryStorage trustBoundaryStorage;
    SystemComponent actor1;

    @Override
    protected void initModel(CapellaModelSkeleton skeleton) {
        this.actor1 = ComponentExt.createSystemActor();
        SystemComponent actor2 = ComponentExt.createSystemActor();
        SystemAnalysis architecture = skeleton.getSystemAnalysis();
        EList systemComponents = architecture.getOwnedSystemComponentPkg().getOwnedSystemComponents();
        systemComponents.add((Object)this.actor1);
        systemComponents.add((Object)actor2);
        this.actor1.setActor(true);
        actor2.setActor(true);
        this.threatSourceUse = CybersecurityFactory.eINSTANCE.createThreatSourceUse();
        this.threatSourceUse.setUsed((Component)this.actor1);
        this.trustBoundaryStorage = CybersecurityFactory.eINSTANCE.createTrustBoundaryStorage();
        this.trustBoundaryStorage.setThreatSource(true);
        this.actor1.getOwnedExtensions().add((Object)this.trustBoundaryStorage);
        this.actor1.getOwnedExtensions().add((Object)this.threatSourceUse);
    }

    public void test() throws Exception {
        this.ok((EObject)this.threatSourceUse, RULE);
        this.executeCommand(() -> {
            this.trustBoundaryStorage.setThreatSource(false);
            this.trustBoundaryStorage.setTrusted(true);
            this.actor1.getOwnedExtensions().add((Object)this.trustBoundaryStorage);
        });
        this.ko((EObject)this.threatSourceUse, RULE);
    }
}

