/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.ui.contribution.migration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellacommon.TransfoLink;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityRealization;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;
import org.polarsys.capella.cybersecurity.CyberSecurityViewpointHelper;
import org.polarsys.capella.cybersecurity.model.CybersecurityConfiguration;
import org.polarsys.capella.cybersecurity.model.CybersecurityQueries;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.SecurityNeeds;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.model.ThreatApplication;
import org.polarsys.capella.cybersecurity.model.ThreatInvolvement;
import org.polarsys.capella.cybersecurity.model.activator.CybersecurityModelActivator;

public class CybersecurityMigrationContribution
extends AbstractMigrationContribution {
    Map<String, String> savedValues = new HashMap<String, String>();
    Map<String, Threat> savedThreats = new HashMap<String, Threat>();
    Map<EObject, String> savedThreatIdLinks = new HashMap<EObject, String>();
    private CybersecurityConfiguration config;
    List<AbstractTrace> transfoToDelete = new ArrayList<AbstractTrace>();
    List<ThreatApplication> threatApplications = new ArrayList<ThreatApplication>();
    List<ThreatInvolvement> threatInvolvments = new ArrayList<ThreatInvolvement>();

    public void unaryMigrationExecute(EObject currentElement, MigrationContext context) {
        if (this.config != null && currentElement instanceof Threat) {
            this.savedThreats.put(((Threat)currentElement).getId(), (Threat)currentElement);
            this.threatMigration((Threat)currentElement);
        }
        if (this.config != null && currentElement instanceof SecurityNeeds) {
            this.securityNeedsMigration((SecurityNeeds)currentElement);
        }
        if (currentElement instanceof ThreatApplication) {
            this.threatApplications.add((ThreatApplication)currentElement);
        }
        if (currentElement instanceof ThreatInvolvement) {
            this.threatInvolvments.add((ThreatInvolvement)currentElement);
        }
    }

    public EStructuralFeature getFeature(EObject object, String prefix, String name, boolean isElement) {
        if (object instanceof PrimaryAsset && name.contains("ownedThreatApplications")) {
            return ModellingcorePackage.Literals.MODEL_ELEMENT__OWNED_MIGRATED_ELEMENTS;
        }
        if (object instanceof Component && name.contains("ownedThreatInvolvements")) {
            return ModellingcorePackage.Literals.MODEL_ELEMENT__OWNED_MIGRATED_ELEMENTS;
        }
        return super.getFeature(object, prefix, name, isElement);
    }

    public void unaryStartMigrationExecute(ExecutionManager executionManager, Resource resource, MigrationContext context) {
        EList ct;
        if (context.getResource().getName().contains(".afm") && !(ct = resource.getContents()).isEmpty() && CyberSecurityViewpointHelper.isViewpointActive((EObject)ct.get(0))) {
            this.config = new CybersecurityModelActivator().createCybersecurityConfiguration();
        }
    }

    public void unaryEndMigrationExecute(ExecutionManager executionManager, Resource resource, MigrationContext context) {
        if (this.config != null && !resource.getContents().isEmpty() && resource.getContents().get(0) instanceof Project) {
            Project project = (Project)resource.getContents().get(0);
            if (CybersecurityQueries.getCybersecurityConfiguration((Project)project) == null) {
                project.getOwnedExtensions().add((Object)this.config);
            }
            if (!this.transfoToDelete.isEmpty()) {
                CapellaDeleteCommand command = new CapellaDeleteCommand(TransactionHelper.getExecutionManager(this.transfoToDelete), this.transfoToDelete, false, false, true);
                if (command.canExecute()) {
                    command.execute();
                }
                this.transfoToDelete.clear();
            }
            this.threatApplications.forEach(this::threatApplicationMigration);
            this.threatInvolvments.forEach(this::threatInvolvementMigration);
        }
    }

    public boolean ignoreUnknownFeature(String prefix, String name, boolean isElement, EObject peekObject, String value, XMLResource resource, MigrationContext context) {
        if (peekObject instanceof Threat && "threatKind".equals(name)) {
            this.savedValues.put(String.valueOf(((Threat)peekObject).getId()) + ":" + name, value);
            return true;
        }
        if (peekObject instanceof SecurityNeeds) {
            this.savedValues.put(String.valueOf(((SecurityNeeds)peekObject).getId()) + ":" + name, value);
            return true;
        }
        if (name.equals("threat") && (peekObject instanceof ThreatApplication || peekObject instanceof ThreatInvolvement)) {
            this.savedThreatIdLinks.put(peekObject, value.substring(1));
            return true;
        }
        return false;
    }

    public void dispose(MigrationContext context) {
        this.savedValues.clear();
        this.config = null;
    }

    private void threatMigration(Threat threat) {
        EnumerationPropertyLiteral literal;
        String searchValue = this.savedValues.get(String.valueOf(threat.getId()) + ":threatKind");
        if (searchValue != null && searchValue.contains("THEFT")) {
            searchValue = "THEFT";
        }
        if ((literal = this.getLiteral(this.config.getThreatKind(), searchValue)) != null) {
            threat.setKind(literal);
        }
        for (AbstractTrace trace : threat.getOutgoingTraces()) {
            if (!(trace instanceof TransfoLink)) continue;
            AbstractCapabilityRealization link = InteractionFactory.eINSTANCE.createAbstractCapabilityRealization();
            link.setTargetElement(trace.getTargetElement());
            link.setSourceElement(trace.getSourceElement());
            ((List)threat.eGet((EStructuralFeature)InteractionPackage.Literals.ABSTRACT_CAPABILITY__OWNED_ABSTRACT_CAPABILITY_REALIZATIONS)).add(link);
            this.transfoToDelete.add(trace);
        }
    }

    private void securityNeedsMigration(SecurityNeeds sn) {
        EnumerationPropertyLiteral literalC = this.getLiteral(this.config.getConfidentiality(), this.savedValues.get(String.valueOf(sn.getId()) + ":confidentiality"));
        EnumerationPropertyLiteral literalI = this.getLiteral(this.config.getIntegrity(), this.savedValues.get(String.valueOf(sn.getId()) + ":integrity"));
        EnumerationPropertyLiteral literalT = this.getLiteral(this.config.getTraceability(), this.savedValues.get(String.valueOf(sn.getId()) + ":traceability"));
        EnumerationPropertyLiteral literalA = this.getLiteral(this.config.getAvailability(), this.savedValues.get(String.valueOf(sn.getId()) + ":availability"));
        if (literalC != null) {
            sn.setConfidentialityValue(literalC);
        }
        if (literalI != null) {
            sn.setIntegrityValue(literalI);
        }
        if (literalT != null) {
            sn.setTraceabilityValue(literalT);
        }
        if (literalA != null) {
            sn.setAvailabilityValue(literalA);
        }
    }

    private void threatApplicationMigration(ThreatApplication threatApplication) {
        if (threatApplication.eContainer() instanceof PrimaryAsset) {
            PrimaryAsset asset = (PrimaryAsset)threatApplication.eContainer();
            String threatId = this.savedThreatIdLinks.get(threatApplication);
            Threat threat = this.savedThreats.get(threatId);
            if (threat != null) {
                threatApplication.setAsset(asset);
                asset.getOwnedMigratedElements().remove((Object)threatApplication);
                threat.getOwnedThreatApplications().add((Object)threatApplication);
            }
        }
    }

    private void threatInvolvementMigration(ThreatInvolvement threatInvolvement) {
        if (threatInvolvement.eContainer() instanceof Component) {
            Component component = (Component)threatInvolvement.eContainer();
            String threatId = this.savedThreatIdLinks.get(threatInvolvement);
            Threat threat = this.savedThreats.get(threatId);
            if (threat != null) {
                threatInvolvement.setComponent(component);
                component.getOwnedMigratedElements().remove((Object)threatInvolvement);
                threat.getOwnedThreatInvolvements().add((Object)threatInvolvement);
            }
        }
    }

    private EnumerationPropertyLiteral getLiteral(EnumerationPropertyType type, String value) {
        Optional<EnumerationPropertyLiteral> result;
        if (value != null && type != null && (result = type.getOwnedLiterals().stream().filter(literal -> literal.getName() != null && literal.getName().equalsIgnoreCase(value.replaceAll("_", " "))).findAny()).isPresent()) {
            return result.get();
        }
        return null;
    }
}

