/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.rules.requirement;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.requirement.RequirementPackage;
import org.polarsys.capella.core.data.requirement.RequirementsTrace;
import org.polarsys.capella.core.transition.common.handlers.attachment.AttachmentHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.transition.system.constants.Messages;
import org.polarsys.capella.core.transition.system.rules.AbstractCapellaElementRule;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IPremise;

public class RequirementsTraceRule
extends AbstractCapellaElementRule {
    protected EClass getSourceType() {
        return RequirementPackage.Literals.REQUIREMENTS_TRACE;
    }

    protected void retrieveRequired(EObject element, List<EObject> result, IContext context) {
        super.retrieveRequired(element, result, context);
        result.add((EObject)((RequirementsTrace)element).getSourceElement());
        result.add((EObject)((RequirementsTrace)element).getTargetElement());
    }

    protected void premicesRelated(EObject eObject1, ArrayList<IPremise> needed) {
        super.premicesRelated(eObject1, needed);
        RequirementsTrace element = (RequirementsTrace)eObject1;
        needed.addAll(this.createDefaultPrecedencePremices((EObject)element, ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT));
        needed.addAll(this.createDefaultPrecedencePremices((EObject)element, ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT));
    }

    protected void retrieveContainer(EObject element, List<EObject> result, IContext context) {
    }

    protected void attachRelated(EObject element, EObject result, IContext context) {
        super.attachRelated(element, result, context);
        AttachmentHelper.getInstance((IContext)context).attachTracedElements(element, result, ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT, context);
        AttachmentHelper.getInstance((IContext)context).attachTracedElements(element, result, ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT, context);
    }

    public IStatus transformRequired(EObject element, IContext context) {
        IStatus result = super.transformRequired(element, context);
        if (result.isOK()) {
            RequirementsTrace ce = (RequirementsTrace)element;
            if (ce.getSourceElement() == null) {
                return new Status(2, org.polarsys.capella.core.transition.common.constants.Messages.Activity_Transformation, Messages.SourceNull);
            }
            if (ce.getTargetElement() == null) {
                return new Status(2, org.polarsys.capella.core.transition.common.constants.Messages.Activity_Transformation, Messages.TargetNull);
            }
            if (!TransformationHandlerHelper.getInstance((IContext)context).isOrWillBeTransformed((EObject)ce.getSourceElement(), context).isOK()) {
                return new Status(2, org.polarsys.capella.core.transition.common.constants.Messages.Activity_Transformation, NLS.bind((String)Messages.SourceBoundNotTransitioned, (Object)EObjectLabelProviderHelper.getText((Object)ce.getSourceElement())));
            }
            if (!TransformationHandlerHelper.getInstance((IContext)context).isOrWillBeTransformed((EObject)ce.getTargetElement(), context).isOK()) {
                return new Status(2, org.polarsys.capella.core.transition.common.constants.Messages.Activity_Transformation, NLS.bind((String)Messages.TargetBoundNotTransitioned, (Object)EObjectLabelProviderHelper.getText((Object)ce.getTargetElement())));
            }
        }
        return result;
    }
}

