/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.scenario.editor.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.properties.controllers.InterfaceHelper;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;

public class SelectInvokedOperationModelForSharedDataAndEvent {
    public static List<CapellaElement> getAvailableExchangeItems(InstanceRole source, InstanceRole target, boolean isSynchronous) {
        AbstractInstance provider;
        AbstractInstance client = source == null ? null : source.getRepresentedInstance();
        AbstractInstance abstractInstance = provider = target == null ? null : target.getRepresentedInstance();
        if (InterfaceHelper.isSharedDataAccess((InstanceRole)source, (InstanceRole)target) && isSynchronous) {
            AbstractInstance temp = client;
            client = provider;
            provider = temp;
        }
        return SelectInvokedOperationModelForSharedDataAndEvent.getAvailableExchangeItems(client, provider, isSynchronous);
    }

    public static List<CapellaElement> getAvailableExchangeItems(AbstractInstance client, AbstractInstance provider, boolean isSynchronous) {
        Interface interf;
        List lst;
        LinkedList clientUsedAndRequiredInterfaces = new LinkedList();
        LinkedList providerImplementedAndProvidedInterfaces = new LinkedList();
        ExchangeItem manipulatedItem = null;
        if (client != null) {
            if (client.getAbstractType() instanceof Component) {
                for (Component component : ComponentExt.getAllAncestors((Component)((Component)client.getAbstractType()))) {
                    clientUsedAndRequiredInterfaces.addAll(InterfaceExt.getAllSuperGeneralizableElements(SelectInvokedOperationModelForSharedDataAndEvent.getUsedAndRequiredInterfaces(component)));
                }
            } else if (client.getAbstractType() instanceof ExchangeItem) {
                lst = EObjectExt.getReferencers((EObject)client.getAbstractType(), (EReference)CsPackage.Literals.EXCHANGE_ITEM_ALLOCATION__ALLOCATED_ITEM);
                for (EObject obj : lst) {
                    interf = (Interface)obj.eContainer();
                    clientUsedAndRequiredInterfaces.addAll(InterfaceExt.getAllSuperGeneralizableElements((Interface)interf));
                }
                manipulatedItem = (ExchangeItem)client.getAbstractType();
            }
        }
        if (provider != null) {
            if (provider.getAbstractType() instanceof Component) {
                for (Component component : ComponentExt.getAllAncestors((Component)((Component)provider.getAbstractType()))) {
                    providerImplementedAndProvidedInterfaces.addAll(InterfaceExt.getAllSuperGeneralizableElements(SelectInvokedOperationModelForSharedDataAndEvent.getImplementedAndProvidedInterfaces(component)));
                }
            } else if (provider.getAbstractType() instanceof ExchangeItem) {
                lst = EObjectExt.getReferencers((EObject)provider.getAbstractType(), (EReference)CsPackage.Literals.EXCHANGE_ITEM_ALLOCATION__ALLOCATED_ITEM);
                for (EObject obj : lst) {
                    interf = (Interface)obj.eContainer();
                    providerImplementedAndProvidedInterfaces.addAll(InterfaceExt.getAllSuperGeneralizableElements((Interface)interf));
                }
                manipulatedItem = (ExchangeItem)provider.getAbstractType();
            }
        }
        ArrayList<CapellaElement> operations = new ArrayList<CapellaElement>();
        for (Interface currentInterface : clientUsedAndRequiredInterfaces) {
            if (!providerImplementedAndProvidedInterfaces.contains(currentInterface)) continue;
            for (ExchangeItemAllocation operation : currentInterface.getOwnedExchangeItemAllocations()) {
                ExchangeItem ei = operation.getAllocatedItem();
                if (manipulatedItem != null && ei != manipulatedItem) continue;
                operations.add((CapellaElement)operation);
            }
        }
        return operations;
    }

    public static List<CapellaElement> getRestrictedExchangeItems(InstanceRole source, InstanceRole target, boolean isSynchronous) {
        return ScenarioExt.getRestrictedExchangeItems((InstanceRole)source, (InstanceRole)target, (boolean)isSynchronous);
    }

    private static List<Interface> getUsedAndRequiredInterfaces(Component component) {
        ArrayList<Interface> result = new ArrayList<Interface>();
        result.addAll((Collection<Interface>)component.getUsedInterfaces());
        result.addAll((Collection<Interface>)component.getRequiredInterfaces());
        for (Feature f : component.getOwnedFeatures()) {
            if (!(f instanceof ComponentPort)) continue;
            ComponentPort p = (ComponentPort)f;
            result.addAll((Collection<Interface>)p.getRequiredInterfaces());
        }
        return result;
    }

    private static List<Interface> getImplementedAndProvidedInterfaces(Component component) {
        ArrayList<Interface> result = new ArrayList<Interface>();
        result.addAll((Collection<Interface>)component.getImplementedInterfaces());
        result.addAll((Collection<Interface>)component.getProvidedInterfaces());
        for (Feature f : component.getOwnedFeatures()) {
            if (!(f instanceof ComponentPort)) continue;
            ComponentPort p = (ComponentPort)f;
            result.addAll((Collection<Interface>)p.getProvidedInterfaces());
        }
        return result;
    }
}

