/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;

public class GeneratorConfigProvider
implements IGeneratorConfigProvider {
    @Inject
    @Named(value="languageName")
    private String languageId;

    public GeneratorConfig install(ResourceSet resourceSet, GeneratorConfig config) {
        GeneratorConfigAdapter adapter = GeneratorConfigAdapter.findInEmfObject((Notifier)resourceSet);
        if (adapter == null) {
            adapter = new GeneratorConfigAdapter();
            adapter.attachToEmfObject((Notifier)resourceSet);
        }
        return adapter.language2GeneratorConfig.put(this.languageId, config);
    }

    @Override
    public GeneratorConfig get(EObject context) {
        GeneratorConfigAdapter adapter;
        ResourceSet resourceSet;
        Resource resource;
        if (context != null && (resource = context.eResource()) != null && (resourceSet = resource.getResourceSet()) != null && (adapter = GeneratorConfigAdapter.findInEmfObject((Notifier)resourceSet)) != null && adapter.language2GeneratorConfig.containsKey(this.languageId)) {
            return adapter.language2GeneratorConfig.get(this.languageId);
        }
        return new GeneratorConfig();
    }

    public static class GeneratorConfigAdapter {
        private final Map<String, GeneratorConfig> language2GeneratorConfig = new HashMap<String, GeneratorConfig>();

        public static GeneratorConfigAdapter findInEmfObject(Notifier emfObject) {
            for (Adapter adapter : emfObject.eAdapters()) {
                if (!(adapter instanceof GeneratorConfigAdapterAdapter)) continue;
                return ((GeneratorConfigAdapterAdapter)adapter).get();
            }
            return null;
        }

        public static GeneratorConfigAdapter removeFromEmfObject(Notifier emfObject) {
            EList adapters = emfObject.eAdapters();
            int max = adapters.size();
            for (int i = 0; i < max; ++i) {
                Adapter adapter = (Adapter)adapters.get(i);
                if (!(adapter instanceof GeneratorConfigAdapterAdapter)) continue;
                emfObject.eAdapters().remove(i);
                return ((GeneratorConfigAdapterAdapter)adapter).get();
            }
            return null;
        }

        public void attachToEmfObject(Notifier emfObject) {
            GeneratorConfigAdapter result = GeneratorConfigAdapter.findInEmfObject(emfObject);
            if (result != null) {
                throw new IllegalStateException("The given EMF object already contains an adapter for GeneratorConfigAdapter");
            }
            GeneratorConfigAdapterAdapter adapter = new GeneratorConfigAdapterAdapter(this);
            emfObject.eAdapters().add((Object)adapter);
        }

        public Map<String, GeneratorConfig> getLanguage2GeneratorConfig() {
            return this.language2GeneratorConfig;
        }

        public static class GeneratorConfigAdapterAdapter
        extends AdapterImpl {
            private GeneratorConfigAdapter element;

            public GeneratorConfigAdapterAdapter(GeneratorConfigAdapter element) {
                this.element = element;
            }

            public GeneratorConfigAdapter get() {
                return this.element;
            }

            public boolean isAdapterForType(Object object) {
                return object == GeneratorConfigAdapter.class;
            }
        }
    }
}

