/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.command;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.core.model.handler.command.DeleteStructureCommand;
import org.polarsys.capella.core.model.handler.command.PreDeleteCommand;
import org.polarsys.capella.core.model.handler.command.PreDeleteHandler;
import org.polarsys.capella.core.model.handler.command.PreRemoveCommand;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;

public class PreDeleteStructureCommand
extends DeleteStructureCommand {
    private PreDeleteHandler handler;

    public PreDeleteStructureCommand(EditingDomain editingDomain, Collection<?> elements, PreDeleteHandler handler) {
        super(editingDomain, elements);
        this.handler = handler;
    }

    @Override
    protected void doPrepare() {
        Collection<DRepresentationDescriptor> allContainedRepresentationsFor = RepresentationHelper.getAllRepresentationDescriptorsTargetedBy(this.getElementsToDelete());
        this.append((Command)new PreRemoveCommand(allContainedRepresentationsFor, this.handler));
        this.append((Command)new PreRemoveCommand(this.getElementsToDelete(), this.handler));
    }

    @Override
    protected void deletePointingReference(EObject referencingEObject, EStructuralFeature feature, EObject referenceToDelete) {
        if (feature.isMany()) {
            this.handler.notifications.add(PreRemoveCommand.createNotification((InternalEObject)referencingEObject, 4, referenceToDelete, feature));
        } else {
            this.handler.notifications.add(PreRemoveCommand.createNotification((InternalEObject)referencingEObject, 1, referenceToDelete, feature));
        }
        this.deleteSemanticStructure(referenceToDelete, referencingEObject, feature);
    }

    @Override
    protected Command doDeleteElement(EObject sourceObject) {
        return new PreDeleteCommand(this.getEditingDomain(), Collections.singletonList(sourceObject), this.handler);
    }

    @Override
    protected Command doDeleteStructure(EObject sourceObject) {
        return new PreDeleteStructureCommand(this.getEditingDomain(), Collections.singletonList(sourceObject), this.handler);
    }

    public boolean canUndo() {
        return false;
    }

    @Override
    protected boolean runAdditionalCommands() {
        return false;
    }

    public void redo() {
    }

    public void undo() {
    }
}

