/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.AbstractMarkerViewContentProvider;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.IViewerRefresh;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.SeverityLevel;

class SeverityContentProvider
extends AbstractMarkerViewContentProvider
implements ITreeContentProvider {
    private Map<SeverityLevel, List<IMarker>> markers = new HashMap<SeverityLevel, List<IMarker>>();

    public SeverityContentProvider(TreeViewer viewer, MarkerViewHelper helper, IViewerRefresh refresh) {
        super(viewer, helper, refresh);
        SeverityLevel[] severityLevelArray = SeverityLevel.values();
        int n = severityLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            SeverityLevel level = severityLevelArray[n2];
            this.markers.put(level, new ArrayList());
            ++n2;
        }
        this.refillCache();
    }

    private void clearCache() {
        SeverityLevel[] severityLevelArray = SeverityLevel.values();
        int n = severityLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            SeverityLevel level = severityLevelArray[n2];
            this.markers.get((Object)level).clear();
            ++n2;
        }
    }

    private void refillCache() {
        this.clearCache();
        Collection<IMarker> found = this.findMarkers();
        for (IMarker marker : found) {
            SeverityLevel level = SeverityLevel.getLevel(marker);
            if (level == null) continue;
            this.markers.get((Object)level).add(marker);
        }
    }

    public synchronized Object[] getElements(Object inputElement) {
        ArrayList<SeverityLevel> result = new ArrayList<SeverityLevel>();
        SeverityLevel[] severityLevelArray = SeverityLevel.values();
        int n = severityLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            SeverityLevel level = severityLevelArray[n2];
            if (!this.markers.get((Object)level).isEmpty()) {
                result.add(level);
            }
            ++n2;
        }
        return result.toArray();
    }

    public synchronized Object[] getChildren(Object parentElement) {
        Object[] result = this.noChildren;
        List<IMarker> children = this.markers.get(parentElement);
        if (children != null) {
            result = children.toArray();
        }
        return result;
    }

    public Object getParent(Object element) {
        SeverityLevel parent = null;
        if (element instanceof IMarker) {
            parent = SeverityLevel.getLevel((IMarker)element);
        }
        return parent;
    }

    public synchronized boolean hasChildren(Object element) {
        List<IMarker> children = this.markers.get(element);
        return children != null && children.size() > 0;
    }

    @Override
    public synchronized void markerAdded(IMarker marker) {
        SeverityLevel level = SeverityLevel.getLevel(marker);
        if (level != null) {
            this.markers.get((Object)level).add(marker);
            this.viewerRefresh.refresh();
        }
    }

    @Override
    public synchronized void markerDeleted(IMarker marker) {
        SeverityLevel[] severityLevelArray = SeverityLevel.values();
        int n = severityLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            SeverityLevel level = severityLevelArray[n2];
            if (this.markers.get((Object)level).remove(marker)) {
                this.viewerRefresh.refresh();
                break;
            }
            ++n2;
        }
    }
}

