/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.factory.stack.primitive.MutableShortStackFactory;
import org.eclipse.collections.api.stack.primitive.MutableShortStack;
import org.eclipse.collections.impl.factory.primitive.ShortStacks;
import org.eclipse.collections.impl.stack.mutable.primitive.ShortArrayStack;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableShortStackFactoryImpl implements MutableShortStackFactory
{
    INSTANCE;


    @Override
    public MutableShortStack empty() {
        return new ShortArrayStack();
    }

    @Override
    public MutableShortStack of() {
        return this.empty();
    }

    @Override
    public MutableShortStack with() {
        return this.empty();
    }

    @Override
    public MutableShortStack of(short ... items) {
        return this.with(items);
    }

    @Override
    public MutableShortStack with(short ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return ShortArrayStack.newStackWith(items);
    }

    @Override
    public MutableShortStack ofAll(ShortIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableShortStack withAll(ShortIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return ShortArrayStack.newStack(items);
    }

    @Override
    public MutableShortStack ofAll(Iterable<Short> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableShortStack withAll(Iterable<Short> iterable) {
        MutableShortStack stack = ShortStacks.mutable.empty();
        Iterate.forEach(iterable, stack::push);
        return stack;
    }

    @Override
    public MutableShortStack ofAllReversed(ShortIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public MutableShortStack withAllReversed(ShortIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return ShortArrayStack.newStackFromTopToBottom(items);
    }
}

