/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.intro.views;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.model.loader.ContentProviderManager;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.part.IntroPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.core.platform.sirius.ui.app.IWelcomeView;
import org.polarsys.capella.core.ui.intro.views.HyperLinkHandler;
import org.polarsys.capella.core.ui.intro.views.WelcomePageContribution;

public class WelcomeView
extends IntroPart
implements IWelcomeView {
    public static final String ID = "org.polarsys.capella.core.ui.intro.views.WelcomeView";
    public static final String EXTENSION_POINT_ID = "org.polarsys.capella.core.ui.intro";
    public static final String EXTENSION_POINT_ID2 = "org.eclipse.ui.intro.configExtension";
    Image banner_icon = null;
    Image compass_icon = null;
    Font titleTextFont = null;
    Font introTextFont = null;
    Font hyperLinkFont = null;
    ScrolledComposite container = null;
    private Set<WelcomePageContribution> internalContributions;
    private Set<WelcomePageContribution> externalContributions;

    public void init(IIntroSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        IntroPlugin.getDefault().closeLaunchBar();
    }

    public void createPartControl(Composite parent) {
        ImageHyperlink hyperlink;
        Composite parentComposite;
        this.container = new ScrolledComposite(parent, 772);
        this.container.setExpandHorizontal(true);
        this.container.setExpandVertical(true);
        this.container.setMinHeight(1000);
        this.container.setMinWidth(900);
        Composite intermediaryComposite = new Composite((Composite)this.container, 4);
        this.container.setContent((Control)intermediaryComposite);
        parent.setBackground(parent.getDisplay().getSystemColor(1));
        intermediaryComposite.setBackground(parent.getDisplay().getSystemColor(1));
        GridLayout mainCompositeGridLayout = GridLayoutFactory.fillDefaults().create();
        mainCompositeGridLayout.numColumns = 1;
        intermediaryComposite.setLayout((Layout)mainCompositeGridLayout);
        GridData mainCompositeGridLayoutData = new GridData(1808);
        mainCompositeGridLayoutData.grabExcessHorizontalSpace = true;
        mainCompositeGridLayoutData.grabExcessVerticalSpace = true;
        intermediaryComposite.setLayoutData((Object)mainCompositeGridLayoutData);
        Canvas viewCanvas = new Canvas(intermediaryComposite, 4);
        GridData viewCanvasLayoutData = new GridData();
        viewCanvasLayoutData.horizontalAlignment = 4;
        viewCanvasLayoutData.heightHint = 180;
        viewCanvasLayoutData.grabExcessHorizontalSpace = true;
        viewCanvas.setLayoutData((Object)viewCanvasLayoutData);
        ImageDescriptor imgDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)EXTENSION_POINT_ID, (String)"icons/ov_banner.jpg");
        try {
            this.banner_icon = imgDesc.createImage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Image finalIcon = this.banner_icon;
        ImageDescriptor imgDesc2 = AbstractUIPlugin.imageDescriptorFromPlugin((String)EXTENSION_POINT_ID, (String)"icons/firststeps-select.png");
        try {
            this.compass_icon = imgDesc2.createImage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Image finalIcon2 = this.compass_icon;
        viewCanvas.addListener(9, e -> {
            GC gc = e.gc;
            Rectangle rect = finalIcon.getBounds();
            Rectangle client = viewCanvas.getClientArea();
            gc.drawImage(finalIcon, rect.x, rect.y, rect.width, rect.height, client.x, client.y, client.width, rect.height);
            gc.drawImage(finalIcon2, 10, 20);
            gc.setBackground(e.display.getSystemColor(1));
            gc.fillRectangle(rect.x, rect.height, client.width, client.height - rect.height);
            this.titleTextFont = new Font((Device)e.display, "Verdana", 21, 0);
            gc.setFont(this.titleTextFont);
            gc.drawText("First Steps", 75, 90, true);
            this.introTextFont = new Font((Device)e.display, "Verdana", 10, 0);
            gc.setFont(this.introTextFont);
            gc.drawText("Getting started with Capella ", 75, 130, true);
        });
        viewCanvas.setBackgroundMode(2);
        Composite itemsComposite = new Composite(intermediaryComposite, 4);
        itemsComposite.setBackgroundMode(2);
        itemsComposite.setBackground(parent.getDisplay().getSystemColor(1));
        GridData itemsCompositeLayoutData = new GridData();
        itemsCompositeLayoutData.horizontalAlignment = 4;
        itemsCompositeLayoutData.verticalAlignment = 4;
        itemsComposite.setLayoutData((Object)itemsCompositeLayoutData);
        GridLayout itemsLayout = GridLayoutFactory.fillDefaults().spacing(new Point(30, 0)).margins(new Point(30, 0)).create();
        itemsComposite.setLayout((Layout)itemsLayout);
        itemsLayout.numColumns = 2;
        Composite topLeftPanel = new Composite(itemsComposite, 4);
        topLeftPanel.setBackgroundMode(2);
        topLeftPanel.setBackground(parent.getDisplay().getSystemColor(1));
        GridLayout leftLayout = GridLayoutFactory.fillDefaults().spacing(new Point(30, 30)).margins(new Point(30, 30)).create();
        topLeftPanel.setLayout((Layout)leftLayout);
        topLeftPanel.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 1).create());
        leftLayout.numColumns = 1;
        Composite topRightPanel = new Composite(itemsComposite, 4);
        topRightPanel.setBackgroundMode(2);
        topRightPanel.setBackground(parent.getDisplay().getSystemColor(1));
        GridLayout rightLayout = GridLayoutFactory.fillDefaults().spacing(new Point(30, 30)).margins(new Point(30, 30)).create();
        topRightPanel.setLayout((Layout)rightLayout);
        topRightPanel.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 1).create());
        rightLayout.numColumns = 1;
        Composite bottomLeftPanel = new Composite(itemsComposite, 4);
        bottomLeftPanel.setBackgroundMode(2);
        bottomLeftPanel.setBackground(parent.getDisplay().getSystemColor(1));
        bottomLeftPanel.setLayout((Layout)leftLayout);
        bottomLeftPanel.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 1).create());
        leftLayout.numColumns = 1;
        Composite bottomRightPanel = new Composite(itemsComposite, 4);
        bottomRightPanel.setBackgroundMode(2);
        bottomRightPanel.setBackground(parent.getDisplay().getSystemColor(1));
        bottomRightPanel.setLayout((Layout)rightLayout);
        bottomRightPanel.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 1).create());
        rightLayout.numColumns = 1;
        this.internalContributions = new LinkedHashSet<WelcomePageContribution>();
        this.externalContributions = new LinkedHashSet<WelcomePageContribution>();
        this.initializeInternalContributions();
        this.initializeContributions();
        HyperlinkGroup group = new HyperlinkGroup(itemsComposite.getDisplay());
        int count = 0;
        for (WelcomePageContribution contrib : this.internalContributions) {
            parentComposite = null;
            parentComposite = count <= this.internalContributions.size() / 2 ? topLeftPanel : topRightPanel;
            hyperlink = this.createHyperlinkFromContribution(contrib, parentComposite);
            group.add((Hyperlink)hyperlink);
            ++count;
        }
        count = 0;
        for (WelcomePageContribution contrib : this.externalContributions) {
            parentComposite = null;
            parentComposite = count <= this.externalContributions.size() / 2 ? bottomLeftPanel : bottomRightPanel;
            hyperlink = this.createHyperlinkFromContribution(contrib, parentComposite);
            group.add((Hyperlink)hyperlink);
            ++count;
        }
    }

    private void initializeContributions() {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        List<IConfigurationElement> externalConfigurationElements = Stream.of(configurationElements).filter(configurationElement -> configurationElement.getContributor() != null && !configurationElement.getContributor().getName().equals(EXTENSION_POINT_ID)).collect(Collectors.toList());
        this.createContributions(externalConfigurationElements, this.externalContributions);
    }

    private void initializeInternalContributions() {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        List<IConfigurationElement> internalConfigurationElements = Stream.of(configurationElements).filter(configurationElement -> configurationElement.getContributor() != null && configurationElement.getContributor().getName().equals(EXTENSION_POINT_ID)).collect(Collectors.toList());
        this.createContributions(internalConfigurationElements, this.internalContributions);
    }

    private ImageHyperlink createHyperlinkFromContribution(WelcomePageContribution contrib, Composite parentComposite) {
        Composite contribComposite = new Composite(parentComposite, 4);
        FillLayout contribLayout = new FillLayout(512);
        GridData contribLayoutData = new GridData();
        contribLayoutData.widthHint = 400;
        contribComposite.setLayout((Layout)contribLayout);
        contribComposite.setLayoutData((Object)contribLayoutData);
        ImageHyperlink hyperLink = new ImageHyperlink(contribComposite, 64);
        hyperLink.setText(contrib.getTitle());
        hyperLink.setHref((Object)contrib.getLink());
        hyperLink.setImage(contrib.getIcon());
        hyperLink.addHyperlinkListener((IHyperlinkListener)contrib.getHandler());
        if (this.hyperLinkFont == null) {
            Font formerFont = hyperLink.getFont();
            FontData[] formerFontData = formerFont.getFontData();
            formerFontData[0].setHeight(11);
            formerFontData[0].setStyle(formerFontData[0].getStyle() | 1);
            this.hyperLinkFont = new Font((Device)parentComposite.getDisplay(), formerFontData[0]);
        }
        hyperLink.setFont(this.hyperLinkFont);
        Composite labelComposite = new Composite(contribComposite, 4);
        GridLayout a = GridLayoutFactory.fillDefaults().extendedMargins(54, 0, 0, 0).create();
        labelComposite.setLayout((Layout)a);
        Label descriptionLabel = new Label(labelComposite, 64);
        descriptionLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        descriptionLabel.setText(contrib.getDescription());
        return hyperLink;
    }

    private void createContributions(List<IConfigurationElement> configurationElements, Set<WelcomePageContribution> contributions) {
        for (IConfigurationElement aConfigurationElement : configurationElements) {
            aConfigurationElement.getContributor();
            IConfigurationElement[] iConfigurationElementArray = aConfigurationElement.getChildren("welcome_contribution");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement handlerExt;
                String clazz;
                IConfigurationElement welcomePageContribution = iConfigurationElementArray[n2];
                String label = welcomePageContribution.getAttribute("label");
                String description = welcomePageContribution.getAttribute("desc");
                String link = welcomePageContribution.getAttribute("link");
                String id = welcomePageContribution.getAttribute("id");
                String iconKey = welcomePageContribution.getAttribute("icon");
                IConfigurationElement[] children = welcomePageContribution.getChildren("handler");
                HyperLinkHandler handler = null;
                if (children.length != 0 && (clazz = (handlerExt = children[0]).getAttribute("class")) != null && !clazz.isBlank()) {
                    try {
                        handler = (HyperLinkHandler)handlerExt.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ImageDescriptor imgDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)welcomePageContribution.getContributor().getName(), (String)iconKey);
                Image icon = null;
                try {
                    icon = imgDesc.createImage();
                }
                catch (Exception e) {
                    // empty catch block
                }
                WelcomePageContribution contribution = new WelcomePageContribution(label, description, id, link, icon, handler);
                contributions.add(contribution);
                ++n2;
            }
        }
    }

    public void standbyStateChanged(boolean standby) {
    }

    public void setFocus() {
    }

    public void dispose() {
        Image icon;
        if (this.compass_icon != null) {
            this.compass_icon.dispose();
        }
        if (this.banner_icon != null) {
            this.banner_icon.dispose();
        }
        if (this.introTextFont != null) {
            this.introTextFont.dispose();
        }
        if (this.titleTextFont != null) {
            this.titleTextFont.dispose();
        }
        if (this.hyperLinkFont != null) {
            this.hyperLinkFont.dispose();
        }
        for (WelcomePageContribution contrib : this.internalContributions) {
            icon = contrib.getIcon();
            if (icon == null) continue;
            icon.dispose();
        }
        for (WelcomePageContribution contrib : this.externalContributions) {
            icon = contrib.getIcon();
            if (icon == null) continue;
            icon.dispose();
        }
        super.dispose();
        IntroPlugin.getDefault().getExtensionPointManager().clear();
        ContentProviderManager.getInst().clear();
    }

    public void saveState(IMemento memento) {
    }

    public Composite getControl() {
        return this.container;
    }
}

