/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.commands;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.jface.viewers.StructuredViewer;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.model.copypaste.SharedCopyPasteElements;
import org.polarsys.capella.common.model.copypaste.SharedCutPasteClipboard;

public class CapellaCutCommand
extends CommandWrapper {
    private Collection<?> _selection;
    private StructuredViewer _viewer;
    private Collection<?> _oldClipboard;

    public CapellaCutCommand(String label, Collection<?> selection, StructuredViewer viewer) {
        super(label);
        this._selection = selection;
        this._viewer = viewer;
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        SharedCopyPasteElements.getInstance().clear();
        SharedCutPasteClipboard clipboard = SharedCutPasteClipboard.getCutClipboard();
        this._oldClipboard = clipboard.getClipboard();
        clipboard.setClipboard(this._selection);
        HashSet<Object> objectsToReflesh = new HashSet<Object>(EcoreUtil2.getAllContents((Collection)clipboard.getClipboard()));
        if (this._oldClipboard != null) {
            objectsToReflesh.addAll(EcoreUtil2.getAllContents(this._oldClipboard));
        }
        this.refreshViewer(objectsToReflesh);
    }

    protected boolean prepare() {
        return true;
    }

    public void redo() {
        this.execute();
    }

    protected void refreshViewer(final Set<Object> elementsToUpdate) {
        this._viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CapellaCutCommand.this._viewer.update(elementsToUpdate.toArray(), null);
            }
        });
    }

    public void undo() {
        Collection currentClipboard;
        HashSet<Object> elementsToUpdate = new HashSet<Object>(0);
        SharedCutPasteClipboard clipboard = SharedCutPasteClipboard.getCutClipboard();
        if (this._oldClipboard != null) {
            elementsToUpdate.addAll(EcoreUtil2.getAllContents(this._oldClipboard));
        }
        if ((currentClipboard = clipboard.getClipboard()) != null) {
            elementsToUpdate.addAll(EcoreUtil2.getAllContents((Collection)currentClipboard));
        }
        clipboard.setClipboard(this._oldClipboard);
        this.refreshViewer(elementsToUpdate);
        this._oldClipboard = currentClipboard;
    }
}

