/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.massactions.shared.menu;

import java.text.MessageFormat;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.common.ui.massactions.shared.helper.CapellaMASelectionHelper;
import org.polarsys.kitalpha.massactions.edit.MEView;
import org.polarsys.kitalpha.massactions.shared.messages.Messages;
import org.polarsys.kitalpha.massactions.shared.view.MAView;

public abstract class AbstractSendToCommandHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(AbstractSendToCommandHandler.class);
    protected CapellaMASelectionHelper selectionHelper = new CapellaMASelectionHelper();

    protected abstract String getCommandParameterPrimaryId();

    protected abstract String getCommandParameterSecondaryId();

    protected abstract String getCommandParameterShouldCreateViewId();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String primaryViewId = event.getParameter(this.getCommandParameterPrimaryId());
        String secondaryViewId = event.getParameter(this.getCommandParameterSecondaryId());
        boolean shouldCreateView = Boolean.parseBoolean(event.getParameter(this.getCommandParameterShouldCreateViewId()));
        secondaryViewId = shouldCreateView ? MEView.getSecondaryViewId() : secondaryViewId;
        try {
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            Collection<EObject> selectionData = this.selectionHelper.getElementsFromSelection(selection);
            if (this.selectionHelper.selectionSharesSameEditingDomain(selectionData)) {
                IViewPart viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(primaryViewId, secondaryViewId, 2);
                MAView maView = (MAView)viewPart;
                if (shouldCreateView) {
                    maView.setViewName(MAView.getViewName((String)maView.getPartName(), (String)secondaryViewId));
                }
                maView.dataChanged(selectionData);
            } else {
                Shell activeSell = Display.getDefault().getActiveShell();
                String dialogContent = MessageFormat.format(Messages.MA_VIEW_MESSAGE_INFO_2, selectionData.size());
                String dialogTitle = Messages.MA_VIEW_NAME;
                MessageDialog.openInformation((Shell)activeSell, (String)dialogTitle, (String)dialogContent);
            }
        }
        catch (PartInitException e) {
            log.error((Object)e.getMessage());
        }
        return null;
    }
}

