/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.services.helper;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;

public class FormHelper {
    public static Composite createCompositeWithLayoutType(FormToolkit toolkit, Composite parent, LayoutType layoutType, int numColumns, boolean equalWidth) {
        Composite result = toolkit.createComposite(parent);
        FormHelper.updateCompositeLayoutWithLayoutType(result, layoutType, numColumns, equalWidth);
        return result;
    }

    public static Couple<Label, Text> createLabelAndText(FormToolkit toolkit, Composite parent, String labelMessage, String initialText, boolean editable) {
        Label label = toolkit.createLabel(parent, labelMessage, 64);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        if (initialText != null) {
            text.setText(initialText);
        }
        text.setEditable(editable);
        return new Couple((Object)label, (Object)text);
    }

    public static Couple<Text, Button> createLabelTextAndButton(FormToolkit toolkit, Composite parent, String labelMessage, String buttonLabel, SelectionListener listener) {
        Couple<Label, Text> labelAndText = FormHelper.createLabelAndText(toolkit, parent, labelMessage, null, true);
        Button button = toolkit.createButton(parent, buttonLabel, 8);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return new Couple((Object)((Text)labelAndText.getValue()), (Object)button);
    }

    public static void createLinkWithDescription(FormToolkit toolkit, Composite parent, Image icon, String linkText, Object linkRef, String linkDescription, IHyperlinkListener listener) {
        ImageHyperlink specificationLink = toolkit.createImageHyperlink(parent, 64);
        specificationLink.setText(linkText);
        if (linkDescription != null) {
            specificationLink.setToolTipText(linkDescription);
        }
        specificationLink.setImage(icon);
        specificationLink.setHref(linkRef);
        specificationLink.addHyperlinkListener(listener);
    }

    public static FormText createRichText(FormToolkit toolkit, Composite parent, String content, IHyperlinkListener listener) {
        FormText text = toolkit.createFormText(parent, false);
        if (content != null) {
            try {
                text.setText(content, true, false);
            }
            catch (SWTException e) {
                text.setText(e.getMessage(), false, false);
            }
        }
        if (listener != null) {
            text.addHyperlinkListener(listener);
        }
        return text;
    }

    public static Couple<Section, Composite> createSectionWithChildComposite(FormToolkit toolkit, Composite parent, int sectionStyle, LayoutType layoutType, int childNumColumns, boolean equalWidth) {
        Section resultingSection = toolkit.createSection(parent, sectionStyle);
        FormHelper.updateControlLayoutDataWithLayoutTypeData((Control)resultingSection, layoutType);
        Composite childComposite = FormHelper.createCompositeWithLayoutType(toolkit, (Composite)resultingSection, layoutType, childNumColumns, equalWidth);
        resultingSection.setClient((Control)childComposite);
        return new Couple((Object)resultingSection, (Object)childComposite);
    }

    public static Couple<Section, Composite> createSectionWithDescription(FormToolkit toolkit, Composite parent, String title, String description) {
        int sectionStyle = 256;
        if (description != null) {
            sectionStyle |= 0x80;
        }
        Couple<Section, Composite> createdSectionWithChildComposite = FormHelper.createSectionWithChildComposite(toolkit, parent, sectionStyle, LayoutType.GRID_LAYOUT, 1, true);
        Section section = (Section)createdSectionWithChildComposite.getKey();
        section.setText(title);
        if (description != null) {
            section.setDescription(description);
        }
        return createdSectionWithChildComposite;
    }

    public static Couple<Section, Composite> createTwistieSectionWithDescription(final IManagedForm managedForm, Composite parent, String title, String description) {
        int sectionStyle = 258;
        if (description != null) {
            sectionStyle |= 0x80;
        }
        Couple<Section, Composite> createdSectionWithChildComposite = FormHelper.createSectionWithChildComposite(managedForm.getToolkit(), parent, sectionStyle, LayoutType.TABLEWRAP_LAYOUT, 1, true);
        Section section = (Section)createdSectionWithChildComposite.getKey();
        section.setLayoutData((Object)new TableWrapData(256));
        section.setText(title);
        if (description != null) {
            section.setDescription(description);
        }
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                managedForm.reflow(false);
            }
        });
        return createdSectionWithChildComposite;
    }

    public static Couple<Section, Composite> createTwistieSectionWithToolbar(Composite sectionContainer, IManagedForm managedForm, String title, String description, boolean isExpanded, List<? extends IAction> toolbarActions) {
        Couple<Section, Composite> createdSection = FormHelper.createTwistieSectionWithDescription(managedForm, sectionContainer, title, description);
        Section section = (Section)createdSection.getKey();
        section.setExpanded(isExpanded);
        if (toolbarActions != null) {
            FormHelper.createSectionToolbar(section, toolbarActions);
        }
        return createdSection;
    }

    public static void forceControlSize(Control control, int widthInChars, int heightInChars) {
        if (control == null || widthInChars <= 0 || heightInChars <= 0) {
            return;
        }
        GC gc = new GC((Drawable)control);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        Object layoutData = control.getLayoutData();
        if (layoutData instanceof GridData) {
            GridData data = (GridData)layoutData;
            data.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)widthInChars);
            data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)heightInChars);
        } else if (layoutData instanceof TableWrapData) {
            TableWrapData data = (TableWrapData)layoutData;
            data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)heightInChars);
        }
    }

    public static Object updateCompositeLayoutWithLayoutType(Composite composite, LayoutType layoutType, int numColumns, boolean equalWidth) {
        GridLayout selectedLayout = null;
        if (LayoutType.GRID_LAYOUT.equals((Object)layoutType)) {
            GridLayout layout = new GridLayout();
            layout.numColumns = numColumns;
            layout.makeColumnsEqualWidth = equalWidth;
            selectedLayout = layout;
        } else if (LayoutType.TABLEWRAP_LAYOUT.equals((Object)layoutType)) {
            TableWrapLayout layout = new TableWrapLayout();
            layout.numColumns = numColumns;
            layout.makeColumnsEqualWidth = equalWidth;
            selectedLayout = layout;
        }
        if (selectedLayout != null) {
            composite.setLayout(selectedLayout);
        }
        return selectedLayout;
    }

    public static Object updateControlLayoutDataWithLayoutTypeData(Control control, LayoutType layoutType) {
        GridData layoutData = null;
        if (LayoutType.GRID_LAYOUT.equals((Object)layoutType)) {
            layoutData = new GridData(4, 4, true, true);
        } else if (LayoutType.TABLEWRAP_LAYOUT.equals((Object)layoutType)) {
            layoutData = new TableWrapData(256);
        }
        if (layoutData != null) {
            control.setLayoutData((Object)layoutData);
        }
        return layoutData;
    }

    public static void createSectionToolbar(Section section, List<? extends IAction> actions) {
        if (actions == null || actions.isEmpty() || section == null) {
            return;
        }
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (handCursor != null && !handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        for (IAction iAction : actions) {
            toolBarManager.add(iAction);
        }
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    public static void adaptRecursively(FormToolkit toolkit, Composite composite) {
        Control[] children;
        if (composite == null || toolkit == null) {
            return;
        }
        toolkit.adapt((Control)composite, true, true);
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control != null) {
                toolkit.adapt(control, true, true);
                if (control instanceof Composite) {
                    FormHelper.adaptRecursively(toolkit, (Composite)control);
                }
            }
            ++n2;
        }
    }

    @Deprecated
    public static void adaptBackgroundColor(Composite composite, Color color, boolean ignoreEditableTextField) {
        FormHelper.adaptBackgroundColor((Control)composite, color, ignoreEditableTextField);
    }

    public static void adaptBackgroundColor(Control composite, Color color, boolean ignoreEditableTextField) {
        boolean applyColor = true;
        if (composite instanceof Text && !ignoreEditableTextField && ((Text)composite).getEditable()) {
            applyColor = false;
        }
        if (composite instanceof StyledText && !ignoreEditableTextField && ((StyledText)composite).getEditable()) {
            applyColor = false;
        }
        if (composite instanceof Table && composite.isEnabled()) {
            applyColor = false;
        }
        if (composite instanceof Tree && composite.isEnabled()) {
            applyColor = false;
        }
        if (composite instanceof CCombo) {
            applyColor = false;
        }
        if (composite instanceof Label && ((Label)composite).getImage() != null) {
            applyColor = false;
        }
        if (applyColor) {
            composite.setBackground(color);
        }
        if (composite instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)composite).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                FormHelper.adaptBackgroundColor(control, color, ignoreEditableTextField);
                ++n2;
            }
        }
    }

    public static enum LayoutType {
        GRID_LAYOUT,
        TABLEWRAP_LAYOUT;

    }
}

