/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.viewers;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Table;

public abstract class AbstractColumnViewerSorter
extends ViewerComparator {
    public static final int ASC = 1;
    public static final int DESC = -1;
    private int _direction = 0;
    private TableViewerColumn _column;
    private ColumnViewer _viewer;

    public int getDirection() {
        return this._direction;
    }

    public AbstractColumnViewerSorter(ColumnViewer viewer, TableViewerColumn column) {
        this._column = column;
        this._viewer = viewer;
    }

    public void update() {
        switch (this._direction) {
            case 1: {
                this.update(-1);
                break;
            }
            case -1: {
                this.update(1);
                break;
            }
            default: {
                this.update(1);
            }
        }
    }

    public void update(int direction) {
        Table table = this._column.getColumn().getParent();
        table.setSortColumn(this._column.getColumn());
        this._direction = direction;
        this._viewer.setComparator((ViewerComparator)this);
        if (direction == 1) {
            table.setSortDirection(1024);
        } else {
            table.setSortDirection(128);
        }
        this._viewer.refresh();
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this._direction * this.doCompare(viewer, e1, e2);
    }

    protected abstract int doCompare(Viewer var1, Object var2, Object var3);
}

