/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.linkedtext.ui.validation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextDocument;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextHyperlink;
import org.polarsys.capella.core.data.information.datavalue.OpaqueExpression;
import org.polarsys.capella.core.linkedtext.ui.CapellaEmbeddedLinkedTextEditorInput;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class OpaqueExpressionHyperlinkCheck
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        OpaqueExpression oe = (OpaqueExpression)ctx.getTarget();
        int i = 0;
        while (i < oe.getLanguages().size()) {
            if ("capella:linkedText".equals(oe.getLanguages().get(i)) && this.hasDanglingReferences(oe, (String)oe.getBodies().get(i))) {
                return ctx.createFailureStatus(new Object[]{EObjectLabelProviderHelper.getText((Object)oe)});
            }
            ++i;
        }
        return ctx.createSuccessStatus();
    }

    private boolean hasDanglingReferences(OpaqueExpression documentBase, String body) {
        CapellaEmbeddedLinkedTextEditorInput.Readonly input = new CapellaEmbeddedLinkedTextEditorInput.Readonly((EObject)documentBase, body);
        try {
            LinkedTextDocument doc = LinkedTextDocument.load((LinkedTextDocument.Input)input);
            for (LinkedTextHyperlink hl : doc.getHyperlinks()) {
                Object o = hl.getTarget();
                if (o != null) continue;
                return true;
            }
        }
        finally {
            input.dispose();
        }
        return false;
    }
}

