/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.interaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.ExtendingQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.business.queries.queries.interaction.GetAvailable_InstanceRole_RepresentedInstance;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.queries.QueryExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentPkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

@ExtendingQuery(extendingQuery=GetAvailable_InstanceRole_RepresentedInstance.class)
public class GetAvailable_InstanceRole_RepresentedInstance__Lib
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        ArrayList<Object> availableElements = new ArrayList<Object>();
        if (capellaElement instanceof InstanceRole) {
            InstanceRole ir = (InstanceRole)capellaElement;
            Scenario scenario = (Scenario)capellaElement.eContainer();
            SystemEngineering sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)capellaElement);
            if (sysEng != null) {
                IModel currentProject = ILibraryManager.INSTANCE.getModel((EObject)capellaElement);
                Collection libraries = LibraryManagerExt.getAllActivesReferences((IModel)currentProject);
                for (IModel library : libraries) {
                    BlockArchitecture block = (BlockArchitecture)QueryExt.getCorrespondingElementInLibrary((EObject)capellaElement, (CapellaModel)((CapellaModel)library));
                    Component rootComponent = block.getSystem();
                    if (rootComponent != null) {
                        GetAvailable_InstanceRole_RepresentedInstance__Lib.getAllOwnedPart(availableElements, rootComponent);
                    }
                    if (scenario.getKind() == ScenarioKind.DATA_FLOW || scenario.getKind() == ScenarioKind.INTERFACE) {
                        if (block instanceof EPBSArchitecture) {
                            SystemEngineering se = (SystemEngineering)block.eContainer();
                            block = SystemEngineeringExt.getPhysicalArchitecture((SystemEngineering)se);
                        }
                        ComponentPkg pkg = BlockArchitectureExt.getComponentPkg((BlockArchitecture)block, (boolean)false);
                        for (Component component : ComponentPkgExt.getAllActors((ComponentPkg)pkg)) {
                            for (AbstractTypedElement ate : component.getAbstractTypedElements()) {
                                if (!(ate instanceof Part)) continue;
                                availableElements.add((Part)ate);
                            }
                        }
                        continue;
                    }
                    if (scenario.getKind() != ScenarioKind.INTERACTION || ir.getRepresentedInstance() instanceof OperationalActivity) continue;
                    TreeIterator iterContents = block.eAllContents();
                    while (iterContents.hasNext()) {
                        Part currentPart;
                        EObject next = (EObject)iterContents.next();
                        if (!(next instanceof Part) || !((currentPart = (Part)next).getAbstractType() instanceof Component) || currentPart.getAbstractType().equals(rootComponent)) continue;
                        availableElements.add(currentPart);
                    }
                }
            }
        }
        return availableElements;
    }

    private static void getAllOwnedPart(Collection<CapellaElement> result, Component rootComponent) {
        for (Part partition : rootComponent.getContainedParts()) {
            result.add((CapellaElement)partition);
            if (!(partition.getAbstractType() instanceof Component)) continue;
            GetAvailable_InstanceRole_RepresentedInstance__Lib.getAllOwnedPart(result, (Component)partition.getAbstractType());
        }
    }
}

