/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.re.updateconnections.ui;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GComparison;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeDialog;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonSideViewer;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonTreeViewer;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.EnhancedComparisonSideViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EnhancedComparisonTreeViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.common.flexibility.properties.loader.PropertiesLoader;
import org.polarsys.capella.common.flexibility.properties.property.PropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IProperties;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.wizards.loader.RenderersLoader;
import org.polarsys.capella.common.flexibility.wizards.renderer.RendererContext;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.flexibility.wizards.ui.PropertyDialog;
import org.polarsys.capella.common.flexibility.wizards.ui.PropertyWizard;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.queries.filters.IQueryFilter;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.common.queries.queryContext.QueryContext;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementKind;
import org.polarsys.capella.core.re.handlers.replicable.ReplicableElementHandler;
import org.polarsys.capella.core.re.updateconnections.ui.ByNameMatcher;
import org.polarsys.capella.core.re.updateconnections.ui.ConnectionMatcher;
import org.polarsys.capella.core.re.updateconnections.ui.DiffmergeHandler;
import org.polarsys.capella.core.re.updateconnections.ui.Messages;
import org.polarsys.capella.core.re.updateconnections.ui.SingleUsePortsMatcher;
import org.polarsys.capella.core.re.updateconnections.ui.SparseModelScope;
import org.polarsys.capella.core.re.updateconnections.ui.properties.CatalogElementSelection;
import org.polarsys.capella.core.re.updateconnections.ui.properties.ConnectionMatcherStrategy;

public class UpdateConnectionsHandler
extends AbstractHandler {
    public static final String RPL_1_PROPERTY = "RPL_1";
    public static final String RPL_2_PROPERTY = "RPL_2";
    public static final String CONNECTION_MATCHER_STRATEGY_PROPERTY = "connectionMatcherStrategy";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<?> selection = this.adaptSelection(((IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event)).toList());
        IProperties properties = new PropertiesLoader().getProperties("updateconnections.properties");
        PropertyContext pcontext = new PropertyContext(properties, (Object)event);
        CatalogElementSelection rpl1 = (CatalogElementSelection)properties.getProperty(RPL_1_PROPERTY);
        rpl1.setAvailableCatalogElements(this.getOrderedAvailableCatalogElements((EObject)selection.get(0), CatalogElementKind.RPL));
        CatalogElementSelection rpl2 = (CatalogElementSelection)properties.getProperty(RPL_2_PROPERTY);
        rpl2.setAvailableCatalogElements(this.getOrderedAvailableCatalogElements((EObject)selection.get(1), CatalogElementKind.RPL));
        ConnectionMatcherStrategy cms = (ConnectionMatcherStrategy)properties.getProperty(CONNECTION_MATCHER_STRATEGY_PROPERTY);
        ArrayList<ConnectionMatcher> availableConnectionMatchers = new ArrayList<ConnectionMatcher>();
        availableConnectionMatchers.add(new SingleUsePortsMatcher());
        availableConnectionMatchers.add(new ByNameMatcher());
        cms.setAvailableConnectionMatchers(availableConnectionMatchers);
        RendererContext rcontext = new RendererContext(new RenderersLoader().getRenderers(properties), (IPropertyContext)pcontext);
        PropertyWizard wizard = new PropertyWizard((IPropertyContext)pcontext, (IRendererContext)rcontext);
        wizard.setWindowTitle(Messages.UpdateConnectionsHandler_0);
        wizard.setHelpAvailable(false);
        PropertyDialog propertyDialog = new PropertyDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (IWizard)wizard);
        propertyDialog.setHelpAvailable(false);
        propertyDialog.create();
        propertyDialog.setTitle(Messages.PropertyDialog_Title);
        if (propertyDialog.open() == 0) {
            CatalogElement selectedRPL1 = (CatalogElement)pcontext.getCurrentValue((IProperty)rpl1);
            CatalogElement selectedRPL2 = (CatalogElement)pcontext.getCurrentValue((IProperty)rpl2);
            ConnectionMatcher connectionMatcher = (ConnectionMatcher)pcontext.getCurrentValue((IProperty)cms);
            EComparison comp = new DiffmergeHandler(selectedRPL1, selectedRPL2, connectionMatcher).computeDifferences((IProgressMonitor)new NullProgressMonitor());
            EMFDiffNode diffNode = new EMFDiffNode((GComparison)comp, (EditingDomain)TransactionHelper.getEditingDomain((EObject)selectedRPL1));
            UpdateConnectionsDiffmergeDialog dialog = new UpdateConnectionsDiffmergeDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), Messages.UpdateConnectionsHandler_0, diffNode);
            dialog.open();
        }
        return null;
    }

    private Collection<CatalogElement> getAllAvailableCatalogElements(EObject selection, final CatalogElementKind kind) {
        return QueryInterpretor.executeQuery((String)"GetAllCatalogElementsForLib", (Object)selection, (IQueryContext)new QueryContext(), (IQueryFilter)new IQueryFilter(){

            public boolean keepElement(Object element, IQueryContext context) {
                return element != null && element instanceof CatalogElement && ((CatalogElement)element).getKind() == kind;
            }
        });
    }

    private Collection<CatalogElement> getOrderedAvailableCatalogElements(EObject selection, CatalogElementKind kind) {
        Collection<CatalogElement> allRPLs = this.getAllAvailableCatalogElements(selection, kind);
        BasicEList result = new BasicEList(allRPLs);
        Collection selectedRPLs = new ReplicableElementHandler().getIndirectlyReplicableElements(null, Collections.singleton(selection));
        int index = 0;
        for (CatalogElement selected : selectedRPLs) {
            result.move(index, (Object)selected);
            ++index;
        }
        return result;
    }

    protected List<?> adaptSelection(List<?> originalSelection) {
        return originalSelection;
    }

    static class SparseScopeTreeContentProvider
    implements ITreeContentProvider,
    SparseModelScope.Listener {
        private final Multimap<EObject, EObject> tree = LinkedHashMultimap.create();
        private final EObject root = EcoreFactory.eINSTANCE.createEObject();
        private SparseModelScope currentScope;

        SparseScopeTreeContentProvider() {
        }

        public void dispose() {
            if (this.currentScope != null) {
                this.currentScope.removeListener(this);
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (this.currentScope != null) {
                this.currentScope.removeListener(this);
            }
            if (newInput == null) {
                this.currentScope = null;
            } else {
                Role role = ((EMFDiffNode)newInput).getRoleForSide(((ComparisonSideViewer)viewer).isLeftSide());
                this.currentScope = (SparseModelScope)((EMFDiffNode)newInput).getActualComparison().getScope(role);
                this.currentScope.addListener(this);
            }
            this.rebuildTree();
        }

        private void rebuildTree() {
            this.tree.clear();
            if (this.currentScope != null) {
                ArrayDeque<EObject> toVisit = new ArrayDeque<EObject>(Lists.newArrayList((Iterator)this.currentScope.getAllContents()));
                while (!toVisit.isEmpty()) {
                    EObject e = (EObject)toVisit.pop();
                    if (this.currentScope.getExternalReferenceElements().contains(e)) continue;
                    if (e.eContainer() != null) {
                        this.tree.put((Object)e.eContainer(), (Object)e);
                        toVisit.push(e.eContainer());
                        continue;
                    }
                    this.tree.put((Object)this.root, (Object)e);
                }
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.tree.get((Object)this.root).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return this.tree.get((Object)((EObject)parentElement)).toArray();
        }

        public Object getParent(Object element) {
            return ((EObject)element).eContainer();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null;
        }

        @Override
        public void scopeChanged() {
            this.rebuildTree();
        }
    }

    static class UpdateConnectionsDiffmergeDialog
    extends DiffMergeDialog {
        public UpdateConnectionsDiffmergeDialog(Shell shell_p, String title_p, EMFDiffNode input_p) {
            super(shell_p, title_p, input_p);
        }

        protected ComparisonViewer createComparisonViewer(Composite parent_p) {
            ComparisonViewer comparisonViewer = new ComparisonViewer(parent_p);
            EnhancedComparisonSideViewer leftViewer = comparisonViewer.getModelScopeViewer(true);
            ((ComparisonSideViewer)leftViewer.getInnerViewer()).setContentProvider((IContentProvider)new SparseScopeTreeContentProvider());
            EnhancedComparisonSideViewer rightViewer = comparisonViewer.getModelScopeViewer(false);
            ((ComparisonSideViewer)rightViewer.getInnerViewer()).setContentProvider((IContentProvider)new SparseScopeTreeContentProvider());
            EnhancedComparisonTreeViewer mainViewer = comparisonViewer.getSynthesisViewer();
            ((ComparisonTreeViewer)mainViewer.getInnerViewer()).addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    IMatch match = (IMatch)element;
                    EMFDiffNode node = (EMFDiffNode)viewer.getInput();
                    SparseModelScope referenceScope = (SparseModelScope)node.getActualComparison().getReferenceScope();
                    SparseModelScope targetScope = (SparseModelScope)node.getActualComparison().getTargetScope();
                    Object refElement = match.get(Role.REFERENCE);
                    if (refElement != null && referenceScope.getExternalReferenceElements().contains(refElement)) {
                        return false;
                    }
                    Object tarElement = match.get(Role.TARGET);
                    return tarElement == null || !targetScope.getExternalReferenceElements().contains(tarElement);
                }
            });
            return comparisonViewer;
        }
    }
}

