/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.obfuscator.actions;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.model.obfuscator.ObfuscatorHelper;

public class ObfuscateSemanticResourceCommand
extends AbstractReadWriteCommand {
    private Resource _resource;

    public ObfuscateSemanticResourceCommand(Resource resource_p) {
        this._resource = resource_p;
    }

    public void run() {
        if (this._resource != null) {
            this.obfuscateSemanticResource(this._resource);
            this._resource = null;
        }
    }

    protected void obfuscateSemanticResource(Resource resource_p) {
        TreeIterator allContents = resource_p.getAllContents();
        while (allContents.hasNext()) {
            EObject currentObject = (EObject)allContents.next();
            if (currentObject == null || currentObject.eIsProxy()) continue;
            this.obfuscateSemanticElement(currentObject);
        }
    }

    protected void obfuscateSemanticElement(EObject object_p) {
        if (object_p.eClass() != null) {
            for (EAttribute attribute : object_p.eClass().getEAllAttributes()) {
                if (!this.isEMFObfuscableEAttribute(object_p, attribute) || !this.isSemanticallyObfuscableEAttribute(object_p, attribute)) continue;
                this.obfuscateEAttribute(object_p, attribute);
            }
        }
    }

    protected boolean isEMFObfuscableEAttribute(EObject object_p, EAttribute attribute_p) {
        if (!attribute_p.isChangeable()) {
            return false;
        }
        if (attribute_p.isDerived()) {
            return false;
        }
        if (attribute_p.isTransient()) {
            return false;
        }
        EAttribute attributeId = object_p.eClass().getEIDAttribute();
        return attributeId == null || !attributeId.equals(attribute_p);
    }

    protected boolean isSemanticallyObfuscableEAttribute(EObject object_p, EAttribute attribute_p) {
        if (ModellingcorePackage.Literals.MODEL_ELEMENT__ID.equals(attribute_p)) {
            return false;
        }
        if (ModellingcorePackage.Literals.MODEL_ELEMENT__SID.equals(attribute_p)) {
            return false;
        }
        if (CapellacorePackage.Literals.KEY_VALUE__KEY.equals(attribute_p) && object_p != null && object_p.eContainer() != null && object_p.eContainer() instanceof Project) {
            return false;
        }
        return !CapellacorePackage.Literals.KEY_VALUE__VALUE.equals(attribute_p) || object_p == null || object_p.eContainer() == null || !(object_p.eContainer() instanceof Project);
    }

    protected void obfuscateEAttribute(EObject currentObject_p, EAttribute attribute_p) {
        try {
            Object value = currentObject_p.eGet((EStructuralFeature)attribute_p);
            if (value != null) {
                if (!attribute_p.isMany()) {
                    if (value instanceof String) {
                        currentObject_p.eSet((EStructuralFeature)attribute_p, (Object)ObfuscatorHelper.generateUnreadableString((String)value));
                    }
                } else if (value instanceof EList) {
                    EList list = (EList)value;
                    Iterator itList = list.iterator();
                    int i = 0;
                    while (itList.hasNext()) {
                        Object itElement = itList.next();
                        if (itElement != null && itElement instanceof String) {
                            list.set(i, (Object)ObfuscatorHelper.generateUnreadableString((String)itElement));
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

