/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.eclipse.capella.ui.trace.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.core.data.capellacore.Namespace;
import org.polarsys.capella.core.data.capellacore.Trace;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.messages.Messages;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.messages.TraceNameHelper;

public class AddTrace
extends AbstractReadWriteCommand {
    private TraceableElement _srcElement;
    private TraceableElement _tgtElement;
    private String _traceType;

    public AddTrace(TraceableElement srcElement_p, TraceableElement tgtElement_p, String traceType_p) {
        this._srcElement = srcElement_p;
        this._tgtElement = tgtElement_p;
        this._traceType = traceType_p;
    }

    public void run() {
        ResourceSet rset = this._srcElement != null ? this._srcElement.eResource().getResourceSet() : this._tgtElement.eResource().getResourceSet();
        Trace trace = TraceNameHelper.getNewTraceInstanceFromTraceName(this._traceType, rset);
        if (trace != null) {
            if (!this._tgtElement.equals(this._srcElement)) {
                trace.setTargetElement(this._tgtElement);
                trace.setSourceElement(this._srcElement);
                if (this._srcElement instanceof Namespace) {
                    this.addOwnedTrace((Namespace)this._srcElement, trace);
                } else {
                    Namespace container = this.getNearestTraceContainer((EObject)this._srcElement);
                    if (container != null) {
                        this.addOwnedTrace(container, trace);
                    } else {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("AddTrace.warning"), (String)Messages.getString("AddTrace.msg1"));
                        trace.destroy();
                    }
                }
            } else {
                trace.destroy();
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("AddTrace.warning"), (String)Messages.getString("AddTrace.msg2"));
            }
        }
    }

    private Namespace getNearestTraceContainer(EObject element_p) {
        if (element_p != null) {
            EObject container = element_p.eContainer();
            if (container != null && container instanceof Namespace) {
                return (Namespace)container;
            }
            return this.getNearestTraceContainer(container);
        }
        return null;
    }

    private void addOwnedTrace(Namespace element_p, Trace trace_p) {
        element_p.getOwnedTraces().add((Object)trace_p);
    }

    public String getName() {
        return "AddTrace";
    }
}

