/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SynchronismKind implements Enumerator
{
    UNSET(0, "UNSET", "UNSET"),
    SYNCHRONOUS(1, "SYNCHRONOUS", "SYNCHRONOUS"),
    ASYNCHRONOUS(2, "ASYNCHRONOUS", "ASYNCHRONOUS");

    public static final int UNSET_VALUE = 0;
    public static final int SYNCHRONOUS_VALUE = 1;
    public static final int ASYNCHRONOUS_VALUE = 2;
    private static final SynchronismKind[] VALUES_ARRAY;
    public static final List<SynchronismKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SynchronismKind[]{UNSET, SYNCHRONOUS, ASYNCHRONOUS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SynchronismKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SynchronismKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SynchronismKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SynchronismKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SynchronismKind get(int value) {
        switch (value) {
            case 0: {
                return UNSET;
            }
            case 1: {
                return SYNCHRONOUS;
            }
            case 2: {
                return ASYNCHRONOUS;
            }
        }
        return null;
    }

    private SynchronismKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

