/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.menu.contributions.pa;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.menu.dynamic.contributions.IMDEMenuItemContribution;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.model.skeleton.impl.cmd.CreatePhysicalArchiCmd;

public class PhysicalArchitectureItemContribution
implements IMDEMenuItemContribution {
    public boolean selectionContribution(ModelElement modelElement, EClass cls, EStructuralFeature feature) {
        if (modelElement instanceof SystemEngineering && PaPackage.Literals.PHYSICAL_ARCHITECTURE.equals(cls) && CapellacorePackage.Literals.ABSTRACT_MODELLING_STRUCTURE__OWNED_ARCHITECTURES.equals(feature)) {
            return ((SystemEngineering)modelElement).getContainedPhysicalArchitectures().isEmpty();
        }
        return false;
    }

    public Command executionContribution(EditingDomain editingDomain, ModelElement containerElement, final ModelElement createdElement, EStructuralFeature feature) {
        if (createdElement instanceof PhysicalArchitecture && containerElement instanceof SystemEngineering) {
            final SystemEngineering engineering = (SystemEngineering)containerElement;
            final LogicalArchitecture architecture = SystemEngineeringExt.getLogicalArchitecture((SystemEngineering)engineering);
            return new RecordingCommand((TransactionalEditingDomain)editingDomain){

                protected void doExecute() {
                    new CreatePhysicalArchiCmd(engineering, NamingConstants.CreatePhysicalArchCmd_name, architecture, (LogicalComponent)architecture.getSystem(), (LogicalFunction)BlockArchitectureExt.getRootFunction((BlockArchitecture)architecture, (boolean)false), (PhysicalArchitecture)createdElement).run();
                }
            };
        }
        return new IdentityCommand();
    }

    public EClass getMetaclass() {
        return PaPackage.Literals.PHYSICAL_ARCHITECTURE;
    }
}

