/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.interfaces.generateInterfaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.activity.InputPin;
import org.polarsys.capella.common.data.activity.OutputPin;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceProvider;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceRequirer;

class ComponentInterfaceAdapter
implements InterfaceProvider,
InterfaceRequirer {
    private final Component component;

    ComponentInterfaceAdapter(Component component) {
        this.component = component;
    }

    public List<FunctionOutputPort> getFunctionOutputPorts() {
        ArrayList<FunctionOutputPort> result = new ArrayList<FunctionOutputPort>();
        for (AbstractFunction function : this.component.getAllocatedFunctions()) {
            for (OutputPin pin : function.getOutputs()) {
                if (!(pin instanceof FunctionOutputPort)) continue;
                result.add((FunctionOutputPort)pin);
            }
        }
        return result;
    }

    @Override
    public Collection<FunctionInputPort> getFunctionInputPorts() {
        ArrayList<FunctionInputPort> result = new ArrayList<FunctionInputPort>();
        for (AbstractFunction function : this.component.getAllocatedFunctions()) {
            for (InputPin pin : function.getInputs()) {
                if (!(pin instanceof FunctionInputPort)) continue;
                result.add((FunctionInputPort)pin);
            }
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentInterfaceAdapter other = (ComponentInterfaceAdapter)obj;
        return !(this.component == null ? other.component != null : !this.component.equals(other.component));
    }

    @Override
    public boolean addRequiredInterface(Interface iface) {
        return false;
    }

    @Override
    public EObject getEObject() {
        return this.component;
    }

    @Override
    public String getText() {
        return EObjectLabelProviderHelper.getText((Object)this.component);
    }

    @Override
    public boolean addProvidedInterface(Interface iface) {
        return false;
    }

    @Override
    public Collection<ComponentExchange> getComponentExchanges() {
        return Collections.emptyList();
    }
}

