/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.interfaces.generateInterfaces;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.ComponentPortInterfaceAdapter;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceGenerationRule;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceInfo;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.ProviderRequirerRole;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.ProviderRequirerTracing;
import org.polarsys.capella.core.tiger.ITransfo;

abstract class Rule_FunctionPort
extends InterfaceGenerationRule {
    private static final ProviderRequirerTracing tracing = new ProviderRequirerTracing();
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("Refinement");

    public Rule_FunctionPort(EClass sourceType, EClass targetType) {
        super(sourceType, targetType);
    }

    abstract Collection<ExchangeItem> getRelatedExchangeItems(FunctionPort var1);

    protected abstract Collection<FunctionalExchange> getRelatedFunctionalExchanges(FunctionPort var1);

    @Override
    protected Collection<InterfaceInfo> transformToInterfaceInfo(EObject element, ITransfo transfo) {
        ArrayList<InterfaceInfo> result = new ArrayList<InterfaceInfo>();
        for (FunctionalExchange fe : this.getRelatedFunctionalExchanges((FunctionPort)element)) {
            if (!this.isExternal(fe, transfo)) continue;
            return Collections.emptyList();
        }
        for (ComponentPort cp : ((FunctionPort)element).getAllocatorComponentPorts()) {
            ComponentPortInterfaceAdapter provider = null;
            ComponentPortInterfaceAdapter requirer = null;
            if (this.getRole() == ProviderRequirerRole.PROVIDER) {
                provider = new ComponentPortInterfaceAdapter(cp);
            } else {
                requirer = new ComponentPortInterfaceAdapter(cp);
            }
            if (this.getRelatedExchangeItems((FunctionPort)element).isEmpty()) continue;
            result.add(new InterfaceInfo(provider, requirer, tracing));
        }
        return result;
    }

    abstract ProviderRequirerRole getRole();

    private boolean isExternal(FunctionalExchange exchange, ITransfo transfo) {
        AbstractFunction sourceF = FunctionalExchangeExt.getSourceFunction((FunctionalExchange)exchange);
        AbstractFunction targetF = FunctionalExchangeExt.getTargetFunction((FunctionalExchange)exchange);
        boolean result = true;
        result &= sourceF != null;
        result &= targetF != null;
        if (!(result &= !sourceF.getAllocationBlocks().isEmpty())) {
            if (!transfo.isDryRun()) {
                String name = sourceF != null ? sourceF.getName() : "Unknown";
                String message = String.valueOf(name) + " has not been allocated to any component";
                logger.warn((Object)new EmbeddedMessage(message, logger.getName(), Arrays.asList(sourceF)));
            }
            return true;
        }
        if (!(result &= !targetF.getAllocationBlocks().isEmpty())) {
            if (!transfo.isDryRun()) {
                String message = String.valueOf(targetF.getName()) + " has not been allocated to any component";
                logger.warn((Object)new EmbeddedMessage(message, logger.getName(), Arrays.asList(targetF)));
            }
            return true;
        }
        return result &= sourceF.getAllocationBlocks().get(0) != targetF.getAllocationBlocks().get(0);
    }
}

