/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.wizards.dialogs;

import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.TreeItem;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationModelHelpers;
import org.polarsys.capella.core.data.information.ExchangeItem;

public class EIAllocationDropAdapter
extends ViewerDropAdapter {
    private final TreeViewer sourceViewer;
    private final TreeViewer targetViewer;

    public EIAllocationDropAdapter(TreeViewer sourceViewer, TreeViewer targetViewer) {
        super((Viewer)targetViewer);
        this.sourceViewer = sourceViewer;
        this.targetViewer = targetViewer;
    }

    public boolean performDrop(Object data) {
        Object target = this.getCurrentEvent().item.getData();
        if (data instanceof TreeItem[] && this.validateItemsType((TreeItem[])data) && target instanceof FunctionPort) {
            TreeItem[] treeItemArray = (TreeItem[])data;
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object parentData;
                TreeItem item = treeItemArray[n2];
                TreeItem parent = item.getParentItem();
                if (parent != null && (parentData = parent.getData()) instanceof FunctionPort) {
                    EIAllocationModelHelpers.handleAllocation((FunctionPort)parentData, (FunctionPort)target, (ExchangeItem)item.getData());
                    this.targetViewer.refresh();
                    this.sourceViewer.refresh();
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        Object source = LocalTransfer.getInstance().nativeToJava(transferType);
        return this.getCurrentLocation() == 3 && source instanceof TreeItem[] && this.validateItemsType((TreeItem[])source) && target instanceof FunctionPort;
    }

    boolean validateItemsType(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (!(item.getData() instanceof ExchangeItem)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

