/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.wizards.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.polarsys.capella.common.data.activity.ActivityPackage;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.ui.menu.dynamic.DynamicCreateChildAction;
import org.polarsys.capella.common.ui.toolkit.dialogs.AbstractViewerDialog;
import org.polarsys.capella.common.ui.toolkit.viewers.menu.ModalContextMenuExtender;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.ui.wizards.actions.DeleteElementAction;
import org.polarsys.capella.core.data.fa.ui.wizards.actions.MakeLinkAction;
import org.polarsys.capella.core.data.fa.ui.wizards.actions.RemoveElementAction;
import org.polarsys.capella.core.data.fa.ui.wizards.actions.StartLinkAction;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.DynamicCreateContributionItem;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationContentProvider;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationDragListener;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationDropAdapter;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationLabelProvider;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationModelHelpers;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationTreeViewer;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.EIAllocationTreeViewerCellModifier;
import org.polarsys.capella.core.data.fa.ui.wizards.dialogs.LinkManager;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class EIAllocationTransfertDlg
extends AbstractViewerDialog {
    protected Text statusBarText;
    protected LinkManager linkManager = new LinkManager();
    protected EIAllocationTreeViewer sepViewer;
    protected EIAllocationTreeViewer tepViewer;
    protected List<ModelElement> selectedElements;
    protected List<ModelElement> transitionedElements;
    public static final String EIALLOCATION_SOURCE_VIEWER = "org.polarsys.capella.core.data.fa.ui.wizards.dialogs.eiAllocation.sourcePhase";
    public static final String EIALLOCATION_TARGET_VIEWER = "org.polarsys.capella.core.data.fa.ui.wizards.dialogs.eiAllocation.targetPhase";
    private static final String MSG_PATTERN = "[%s][%s] %s";
    private static final String PATH_SEPARATOR = "::";
    private boolean isAlreadyUpdatingSelection = false;

    public EIAllocationTransfertDlg(Shell parentShell, String dialogTitle, String dialogMessage, String shellTitle) {
        super(parentShell, dialogTitle, dialogMessage, shellTitle);
    }

    protected void doCreateDialogArea(Composite dialogAreaComposite) {
        Composite treeComposite = new Composite(dialogAreaComposite, 0x1000000);
        treeComposite.setLayout((Layout)new FillLayout(256));
        GridData gdData = new GridData(1808);
        gdData.horizontalAlignment = 4;
        gdData.grabExcessHorizontalSpace = true;
        gdData.grabExcessVerticalSpace = true;
        gdData.heightHint = 400;
        gdData.widthHint = 600;
        treeComposite.setLayoutData((Object)gdData);
        this.sepViewer = new EIAllocationTreeViewer(treeComposite);
        this.tepViewer = new EIAllocationTreeViewer(treeComposite);
        this.sepViewer.setGroupLabel("Source Engineering Phase" + this.getArchitectureName(this.selectedElements));
        this.sepViewer.getTreeViewer().setContentProvider((IContentProvider)new EIAllocationContentProvider());
        this.sepViewer.getTreeViewer().setLabelProvider((IBaseLabelProvider)new EIAllocationLabelProvider(this.linkManager, this.sepViewer, true));
        this.sepViewer.getTreeViewer().setColumnProperties(new String[]{ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME.getName()});
        this.sepViewer.getTreeViewer().setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.sepViewer.getTreeViewer().getTree(), 2048)});
        this.sepViewer.getTreeViewer().setCellModifier((ICellModifier)new EIAllocationTreeViewerCellModifier(this.sepViewer.getTreeViewer().getTree()));
        this.sepViewer.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EIAllocationTransfertDlg.this.updateSelection((ITreeSelection)event.getSelection(), false, EIAllocationTransfertDlg.this.tepViewer, EIAllocationTransfertDlg.this.sepViewer);
            }
        });
        this.sepViewer.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EIAllocationTransfertDlg.this.handleDbClick(event, EIAllocationTransfertDlg.this.sepViewer.getTreeViewer());
            }
        });
        this.sepViewer.getTreeViewer().getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                EIAllocationTransfertDlg.this.handleNotification(event, EIAllocationTransfertDlg.this.sepViewer);
            }
        });
        this.sepViewer.setInput(this.selectedElements);
        this.tepViewer.setGroupLabel("Target Engineering Phase" + this.getArchitectureName(this.transitionedElements));
        this.tepViewer.getTreeViewer().setUseHashlookup(true);
        this.tepViewer.getTreeViewer().setContentProvider((IContentProvider)new EIAllocationContentProvider());
        this.tepViewer.getTreeViewer().setLabelProvider((IBaseLabelProvider)new EIAllocationLabelProvider(this.linkManager, this.tepViewer, false));
        this.tepViewer.getTreeViewer().setColumnProperties(new String[]{ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME.getName()});
        this.tepViewer.getTreeViewer().setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.tepViewer.getTreeViewer().getTree(), 2048)});
        this.tepViewer.getTreeViewer().setCellModifier((ICellModifier)new EIAllocationTreeViewerCellModifier(this.tepViewer.getTreeViewer().getTree()));
        this.tepViewer.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EIAllocationTransfertDlg.this.updateSelection((ITreeSelection)event.getSelection(), true, EIAllocationTransfertDlg.this.sepViewer, EIAllocationTransfertDlg.this.tepViewer);
            }
        });
        this.tepViewer.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EIAllocationTransfertDlg.this.handleDbClick(event, EIAllocationTransfertDlg.this.tepViewer.getTreeViewer());
            }
        });
        this.tepViewer.getTreeViewer().getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                EIAllocationTransfertDlg.this.handleNotification(event, EIAllocationTransfertDlg.this.tepViewer);
            }
        });
        this.tepViewer.setInput(this.transitionedElements);
        this.registerContextualMenu(this.sepViewer.getTreeViewer(), false);
        this.registerContextualMenu(this.tepViewer.getTreeViewer(), true);
        this.createStatusTextField(dialogAreaComposite);
        this.createDragDropSourceTargets();
    }

    protected void handleDbClick(DoubleClickEvent event, TreeViewer treeViewer) {
        ITreeSelection selection = (ITreeSelection)event.getSelection();
        if (!selection.isEmpty()) {
            Object data = selection.getFirstElement();
            ((EIAllocationTreeViewerCellModifier)treeViewer.getCellModifier()).setEnabled(true);
            treeViewer.editElement(data, 0);
        }
    }

    protected void handleNotification(Event event, EIAllocationTreeViewer treeViewer) {
        ((EIAllocationTreeViewerCellModifier)treeViewer.getTreeViewer().getCellModifier()).setEnabled(false);
        if ("renamed_notification".equals(event.text)) {
            this.refreshViewers(true);
            this.updateStatusBar(event.data, treeViewer);
        }
    }

    protected void updateSelection(ITreeSelection selection, boolean isTEP, EIAllocationTreeViewer updatedViewer, EIAllocationTreeViewer menuViewer) {
        if (!this.isAlreadyUpdatingSelection) {
            this.isAlreadyUpdatingSelection = true;
            if (selection.size() == 1) {
                ModelElement selectedElement = (ModelElement)selection.getFirstElement();
                if (selectedElement instanceof ExchangeItem) {
                    this.selectExchangeItem((ExchangeItem)selectedElement, updatedViewer);
                } else {
                    List<ModelElement> elts = isTEP ? EIAllocationModelHelpers.getTransitionerElements(selectedElement) : EIAllocationModelHelpers.getTransitionedElements(selectedElement);
                    updatedViewer.getTreeViewer().setSelection((ISelection)new StructuredSelection(elts), true);
                }
                this.updateStatusBar((Object)selectedElement, menuViewer);
            } else {
                updatedViewer.getTreeViewer().setSelection(null, true);
                this.updateStatusBar(null);
            }
            this.isAlreadyUpdatingSelection = false;
        }
    }

    protected String getArchitectureName(List<ModelElement> elements) {
        if (!elements.isEmpty()) {
            ModelElement elt = elements.get(0);
            BlockArchitecture arch = BlockArchitectureExt.getRootBlockArchitecture((EObject)elt);
            if (OaPackage.Literals.OPERATIONAL_ANALYSIS.equals(arch.eClass())) {
                return " [OA]";
            }
            if (CtxPackage.Literals.SYSTEM_ANALYSIS.equals(arch.eClass())) {
                return " [SA]";
            }
            if (LaPackage.Literals.LOGICAL_ARCHITECTURE.equals(arch.eClass())) {
                return " [LA]";
            }
            if (PaPackage.Literals.PHYSICAL_ARCHITECTURE.equals(arch.eClass())) {
                return " [PA]";
            }
            if (EpbsPackage.Literals.EPBS_ARCHITECTURE.equals(arch.eClass())) {
                return " [EPBS]";
            }
        }
        return "";
    }

    protected void selectExchangeItem(ExchangeItem exchangeItem, EIAllocationTreeViewer treeViewer) {
        for (EObject obj : EIAllocationModelHelpers.getOwners(exchangeItem)) {
            treeViewer.getTreeViewer().expandToLevel((Object)obj, 1);
        }
        Widget[] widgets = treeViewer.findItems(exchangeItem);
        TreeItem[] items = new TreeItem[widgets.length];
        int i = 0;
        while (i < widgets.length) {
            items[i] = (TreeItem)widgets[i];
            ++i;
        }
        treeViewer.getTreeViewer().getTree().setSelection(items);
    }

    protected void registerContextualMenu(TreeViewer treeViewer, final boolean isTEP) {
        MenuManager menuMgr = new MenuManager();
        if (isTEP) {
            menuMgr.add((IContributionItem)new DynamicCreateContributionItem(treeViewer));
        }
        menuMgr.add((IContributionItem)new ActionContributionItem((IAction)new DeleteElementAction(treeViewer){

            @Override
            protected void postRun() {
                EIAllocationTransfertDlg.this.refreshViewers(isTEP);
            }
        }));
        menuMgr.add((IContributionItem)new ActionContributionItem((IAction)new RemoveElementAction(treeViewer){

            @Override
            protected void postRun() {
                EIAllocationTransfertDlg.this.refreshViewers(isTEP);
            }
        }));
        menuMgr.add((IContributionItem)new Separator());
        if (isTEP) {
            menuMgr.add((IContributionItem)new ActionContributionItem((IAction)new StartLinkAction(this.linkManager, treeViewer){

                @Override
                protected void postRun() {
                    EIAllocationTransfertDlg.this.refreshViewers(true);
                }
            }));
        } else {
            menuMgr.add((IContributionItem)new ActionContributionItem((IAction)new MakeLinkAction(this.linkManager, treeViewer){

                @Override
                protected void postRun() {
                    EIAllocationTransfertDlg.this.refreshViewers(true);
                }
            }));
        }
        Menu menu = menuMgr.createContextMenu(treeViewer.getControl());
        treeViewer.getControl().setMenu(menu);
        ModalContextMenuExtender.registerContextMenu((MenuManager)menuMgr, (String)(!isTEP ? EIALLOCATION_SOURCE_VIEWER : EIALLOCATION_TARGET_VIEWER), (ISelectionProvider)treeViewer);
    }

    protected void refreshViewers(boolean isTEP) {
        this.sepViewer.getTreeViewer().refresh(true);
        if (isTEP) {
            this.tepViewer.getTreeViewer().refresh(true);
        }
    }

    protected List<Action> getAddElementActions(IStructuredSelection selection, final TreeViewer treeViewer) {
        ArrayList<Action> actions = new ArrayList<Action>();
        final Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof AbstractFunction) {
            TransactionalEditingDomain editingDomain = TransactionHelper.getEditingDomain((EObject)((EObject)selectedElement));
            for (final CommandParameter cmd : editingDomain.getNewChildDescriptors(selectedElement, null)) {
                final EReference ref = cmd.getEReference();
                final EObject value = cmd.getEValue();
                if (!FaPackage.Literals.ABSTRACT_FUNCTION__OWNED_FUNCTIONS.equals(ref) && !ActivityPackage.Literals.ABSTRACT_ACTION__INPUTS.equals(ref) && !ActivityPackage.Literals.ABSTRACT_ACTION__OUTPUTS.equals(ref)) continue;
                actions.add((Action)new DynamicCreateChildAction((EditingDomain)editingDomain, (ISelection)selection, cmd){

                    public void run() {
                        EPackage pkg = value.eClass().getEPackage();
                        EFactory factory = pkg.getEFactoryInstance();
                        EObject obj = factory.create(value.eClass());
                        ((Collection)((EObject)selectedElement).eGet((EStructuralFeature)ref)).add(obj);
                        String name = EcoreUtil2.getUniqueName((EObject)obj, (EObject)((EObject)selectedElement), (EStructuralFeature)ref, (EAttribute)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (String)obj.eClass().getName());
                        obj.eSet((EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (Object)name);
                        treeViewer.refresh(true);
                    }

                    public String getText() {
                        ItemProviderAdapter itemProvider = EObjectLabelProviderHelper.getItemProvider((EObject)cmd.getEValue());
                        String metaclassLabel = EObjectLabelProviderHelper.getMetaclassLabel((EClass)cmd.getEValue().eClass(), (ItemProviderAdapter)itemProvider);
                        return metaclassLabel;
                    }
                });
            }
        }
        return actions;
    }

    protected void createDragDropSourceTargets() {
        int operations = 2;
        Transfer[] transferTypes = new Transfer[]{LocalTransfer.getInstance()};
        this.sepViewer.getTreeViewer().addDragSupport(operations, transferTypes, (DragSourceListener)new EIAllocationDragListener(this.sepViewer.getTreeViewer()));
        this.tepViewer.getTreeViewer().addDropSupport(operations, transferTypes, (DropTargetListener)new EIAllocationDropAdapter(this.sepViewer.getTreeViewer(), this.tepViewer.getTreeViewer()));
    }

    private void createStatusTextField(Composite parent) {
        this.statusBarText = new Text(parent, 2056);
        this.statusBarText.setEditable(false);
        GridData gdData = new GridData();
        gdData.horizontalAlignment = 4;
        gdData.grabExcessHorizontalSpace = true;
        gdData.grabExcessVerticalSpace = false;
        gdData.horizontalSpan = 2;
        this.statusBarText.setLayoutData((Object)gdData);
    }

    public void setSelection(List<ModelElement> selectedElements, List<ModelElement> transitionedElements) {
        this.selectedElements = selectedElements;
        this.transitionedElements = transitionedElements;
    }

    public Object getResult() {
        return null;
    }

    protected void updateStatusBar(Object element) {
        this.updateStatusBar(element, Collections.EMPTY_LIST);
    }

    protected void updateStatusBar(Object element, EIAllocationTreeViewer treeViewer) {
        this.updateStatusBar(element, treeViewer.findItem(element));
    }

    protected void updateStatusBar(Object element, Widget widget) {
        Object data;
        ArrayList<String> messages = new ArrayList<String>();
        if (widget != null && (data = widget.getData("Validation")) instanceof IStatus) {
            IStatus status = (IStatus)data;
            if (status.isMultiStatus()) {
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus child = iStatusArray[n2];
                    messages.add(String.format(MSG_PATTERN, this.getSeverity(child), this.getRuleId(child), child.getMessage()));
                    ++n2;
                }
            } else {
                messages.add(String.format(MSG_PATTERN, this.getSeverity(status), this.getRuleId(status), status.getMessage()));
            }
        }
        this.updateStatusBar(element, messages);
    }

    private String getRuleId(IStatus status) {
        if (status instanceof ConstraintStatus) {
            IConstraintDescriptor desc = ((ConstraintStatus)status).getConstraint().getDescriptor();
            return desc.getId().replace(String.valueOf(desc.getPluginId()) + ".", "");
        }
        return "";
    }

    private String getSeverity(IStatus status) {
        switch (status.getSeverity()) {
            case 1: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
            case 4: {
                return "ERROR";
            }
        }
        return "";
    }

    protected void updateStatusBar(Object element, List<String> messages) {
        if (element instanceof AbstractNamedElement) {
            AbstractNamedElement elt = (AbstractNamedElement)element;
            SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ExtensibleElement)elt);
            String path = this.getPath(systemEngineering, elt);
            this.statusBarText.setText("[" + messages.size() + " warning/error(s)] " + (path == null ? "" : path));
            if (messages.size() > 0) {
                String tooltip = "";
                int i = 0;
                while (i < messages.size()) {
                    tooltip = String.valueOf(tooltip) + messages.get(i);
                    if (i < messages.size() - 1) {
                        tooltip = String.valueOf(tooltip) + "\n";
                    }
                    ++i;
                }
                this.statusBarText.setToolTipText(tooltip);
            } else {
                this.statusBarText.setToolTipText(null);
            }
        } else {
            this.statusBarText.setText("");
            this.statusBarText.setToolTipText(null);
        }
    }

    public String getPath(SystemEngineering sysEng, AbstractNamedElement target) {
        String name;
        String string = name = target instanceof ExchangeItemAllocation ? ((ExchangeItemAllocation)target).getAllocatedItem().getName() : target.getName();
        if (name == null) {
            name = "";
        }
        StringBuffer path = new StringBuffer(name);
        EObject container = target.eContainer();
        if (container instanceof AbstractNamedElement) {
            AbstractNamedElement parent = (AbstractNamedElement)target.eContainer();
            if (parent != sysEng) {
                path.insert(path.indexOf(path.toString()), String.valueOf(this.getPath(sysEng, parent)) + PATH_SEPARATOR);
            } else {
                path.insert(path.indexOf(path.toString()), String.valueOf(parent.getName()) + PATH_SEPARATOR);
            }
        }
        return path.toString();
    }
}

