/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.time.Year;
import java.util.Properties;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.internal.jobs.JobMessages;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchErrorHandler;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.application.IDEWorkbenchAdvisor;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.WorkbenchStatusDialogManager;
import org.polarsys.capella.common.platform.sirius.customisation.SiriusCustomizationPlugin;
import org.polarsys.capella.common.tools.report.appenders.usage.UsageMonitoringLogger;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;
import org.polarsys.capella.core.model.handler.advisor.DelegateWorkbenchAdvisor;
import org.polarsys.capella.core.platform.sirius.ui.app.CapellaWorkbenchWindowAdvisor;

public class CapellaWorkbenchAdvisor
extends IDEWorkbenchAdvisor {
    private static final String CONFIGURATION_FOLDER_SHORT_NAME = "configuration";
    private static final String CONFIG_INI_FILE_SHORT_NAME = "config.ini";
    private static final String CATEGORY_DEVELOPMENT = "org.eclipse.categories.developmentCategory";
    private static final String CATEGORY_TEAM = "org.eclipse.categories.teamCategory";
    private static final String CATEGORY_TEAM_CVS = "org.eclipse.team.cvs";
    private static final String CAPELLA_VERSION_TAG = "CapellaVersion";
    private static final String BUILD_ID_TAG = "BuildId";
    private static final String CURRENT_YEAR = "CurrentYear";
    private static final int limitLengthOfPath = 115;
    private static final int fileCharAdd = 6;
    private AbstractStatusHandler ideWorkbenchErrorHandler;

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new CapellaWorkbenchWindowAdvisor(this, configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return "capella.sirius.perspective";
    }

    public void preStartup() {
        String bundleVersion;
        int index;
        super.preStartup();
        SiriusCustomizationPlugin.getDefault();
        IUndoContext workspaceUndoContext = WorkspaceUndoUtil.getWorkspaceUndoContext();
        OperationHistoryFactory.getOperationHistory().setLimit(workspaceUndoContext, 0);
        IProduct product = Platform.getProduct();
        if (product != null && (index = (bundleVersion = (String)product.getDefiningBundle().getHeaders().get("Bundle-version")).lastIndexOf(46)) >= 0) {
            System.setProperty(CAPELLA_VERSION_TAG, bundleVersion.substring(0, index));
            System.setProperty(BUILD_ID_TAG, bundleVersion.substring(index + 1));
        }
        System.setProperty(CURRENT_YEAR, Year.now().toString());
        DelegateWorkbenchAdvisor.INSTANCE.callPreStartup();
        this.removeAllAcceleoIntroExtensionPoints();
        UsageMonitoringLogger.getInstance();
        String workaround = "eclipse.workaround.bug467000";
        if (System.getProperty(workaround) == null) {
            System.setProperty(workaround, Boolean.TRUE.toString());
        }
    }

    public void postShutdown() {
        super.postShutdown();
        IPath configFileUsedByRuntime = new Path(Platform.getConfigurationLocation().getURL().getFile()).append(CONFIG_INI_FILE_SHORT_NAME);
        IPath configFileFromInstallation = new Path(Platform.getInstallLocation().getURL().getFile()).append("configuration/config.ini");
        File installationConfigFile = configFileFromInstallation.toFile();
        if (installationConfigFile.exists() && !configFileUsedByRuntime.equals((Object)configFileFromInstallation)) {
            Properties configFileAsProperties = new Properties();
            try {
                Throwable throwable = null;
                Object var6_9 = null;
                try (FileInputStream openStream = new FileInputStream(installationConfigFile);){
                    configFileAsProperties.load(openStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                throwable = null;
                var6_9 = null;
                try (FileOutputStream out = new FileOutputStream(configFileUsedByRuntime.toFile());){
                    configFileAsProperties.store(out, "This configuration file was written by Capella");
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception_p) {
                exception_p.printStackTrace();
            }
        }
        DelegateWorkbenchAdvisor.INSTANCE.callPostShutdown();
    }

    public void postStartup() {
        DelegateWorkbenchAdvisor.INSTANCE.callPostStartup();
        super.postStartup();
        PreferencesHelper.removeEclipseProjectReferences((String)"capella.sirius.perspective");
        try {
            ModelValidationService.getInstance().loadXmlConstraintDeclarations();
            PreferencesHelper.initializeCapellaPreferencesFromEPFFile();
            File systemDirectory = new File(System.getProperty("eclipse.home.location"));
            int lengthDirectory = systemDirectory.toString().substring(6).length();
            if (System.getProperty("os.name").contains("Windows") && lengthDirectory > 115) {
                IDEWorkbenchPlugin.log((String)"The current installation path is too long (Windows Maximum Path Length Limitation). Certain components such as Capella Properties description may not work properly.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean preShutdown() {
        DelegateWorkbenchAdvisor.INSTANCE.callPreShutdown();
        return super.preShutdown();
    }

    private void removeAllAcceleoIntroExtensionPoints() {
        try {
            IConfigurationElement[] extensionPointArray;
            Field privateStringField = ExtensionRegistry.class.getDeclaredField("masterToken");
            privateStringField.setAccessible(true);
            Object masterToken = privateStringField.get(Platform.getExtensionRegistry());
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.intro.configExtension");
            IConfigurationElement[] iConfigurationElementArray = extensionPointArray = extensionPoint.getConfigurationElements();
            int n = extensionPointArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getNamespaceIdentifier() != null && element.getNamespaceIdentifier().equals("org.eclipse.acceleo.ide.ui") && element.getAttribute("configId").equals("org.eclipse.ui.intro.universalConfig")) {
                    Platform.getExtensionRegistry().removeExtension(element.getDeclaringExtension(), masterToken);
                    break;
                }
                ++n2;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public synchronized AbstractStatusHandler getWorkbenchErrorHandler() {
        if (this.ideWorkbenchErrorHandler == null) {
            this.ideWorkbenchErrorHandler = new IDEWorkbenchErrorHandler(this.getWorkbenchConfigurer()){

                protected void configureStatusDialog(WorkbenchStatusDialogManager statusDialog) {
                    statusDialog.setMessageDecorator(new ILabelDecorator(){

                        public String decorateText(String text, Object element) {
                            Throwable exception;
                            IStatus status;
                            if (element instanceof StatusAdapter && text != null && (status = ((StatusAdapter)element).getStatus()) != null && (exception = status.getException()) != null && exception.getMessage() != null && status.getMessage() != null && !status.getMessage().equals(exception.getMessage())) {
                                if ("org.eclipse.core.jobs".equals(status.getPlugin()) && text.startsWith(JobMessages.jobs_internalError.substring(0, 30))) {
                                    return WorkbenchMessages.WorkbenchStatusDialog_SeeDetails;
                                }
                                if (text.equals(status.getException().getMessage())) {
                                    return WorkbenchMessages.WorkbenchStatusDialog_SeeDetails;
                                }
                            }
                            return text;
                        }

                        public void removeListener(ILabelProviderListener listener) {
                        }

                        public boolean isLabelProperty(Object element, String property) {
                            return false;
                        }

                        public void dispose() {
                        }

                        public void addListener(ILabelProviderListener listener) {
                        }

                        public Image decorateImage(Image image, Object element) {
                            return image;
                        }
                    });
                }
            };
        }
        return this.ideWorkbenchErrorHandler;
    }
}

