/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.services;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.polarsys.capella.core.platform.sirius.ui.services.IElementIdentifierService;

public class ElementIdentifierService
implements IElementIdentifierService {
    private static final String SEPARATOR = ".";
    private Map<String, String> viewpointShortNames = new HashMap<String, String>();

    public ElementIdentifierService() {
        this.viewpointShortNames.put("Common", "common");
        this.viewpointShortNames.put("Operational Analysis", "oa");
        this.viewpointShortNames.put("System Analysis", "sa");
        this.viewpointShortNames.put("Logical Architecture", "la");
        this.viewpointShortNames.put("Physical Architecture", "pa");
        this.viewpointShortNames.put("EPBS architecture", "epbs");
    }

    @Override
    public String getIdentifier(DiagramDescription diagram, IdentifiedElement element) {
        Objects.requireNonNull(diagram);
        Objects.requireNonNull(element);
        EObject diagramContainer = diagram.eContainer();
        if (diagramContainer instanceof Viewpoint) {
            Viewpoint viewpoint = (Viewpoint)diagramContainer;
            String id = this.getViewpointShortName(viewpoint);
            id = String.valueOf(id) + SEPARATOR + this.getDiagramShortName((RepresentationDescription)diagram);
            id = String.valueOf(id) + SEPARATOR + element.getName();
            return id;
        }
        return null;
    }

    private String getViewpointShortName(Viewpoint viewpoint) {
        return this.viewpointShortNames.getOrDefault(viewpoint.getName(), viewpoint.getName());
    }

    private String getDiagramShortName(RepresentationDescription representationDescription) {
        String[] tokens;
        String titleExpression = representationDescription.getTitleExpression();
        if (titleExpression != null && (tokens = (titleExpression = titleExpression.replace("&", "n")).split("(\\[)|(\\])")).length == 3 && !tokens[1].contains("self")) {
            return tokens[1].toLowerCase();
        }
        tokens = representationDescription.getName().split(" ");
        StringBuilder result = new StringBuilder();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            char letter = Character.toLowerCase(token.charAt(0));
            result.append(letter);
            ++n2;
        }
        return result.toString();
    }

    @Override
    public String getIdentifier(RepresentationDescription representationDescription) {
        if (representationDescription.eContainer() instanceof Viewpoint) {
            String id = this.getViewpointShortName((Viewpoint)representationDescription.eContainer());
            if (representationDescription != null) {
                id = String.valueOf(id) + SEPARATOR + this.getDiagramShortName(representationDescription);
            }
            return id;
        }
        return null;
    }

    @Override
    public String getIdentifier(Viewpoint viewpoint) {
        return this.getViewpointShortName(viewpoint);
    }
}

