/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.clipboard.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.api.part.IDiagramDialectGraphicalViewer;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.platform.sirius.clipboard.util.MiscUtil;

public final class LayerUtil {
    private LayerUtil() {
    }

    public static View getGmfElement(EditPart editPart_p) {
        Object modelElement;
        View result = null;
        if (editPart_p != null && (modelElement = editPart_p.getModel()) instanceof View) {
            result = (View)modelElement;
        }
        return result;
    }

    public static DSemanticDecorator getSiriusElement(View view_p) {
        EObject representedElement;
        DSemanticDecorator result = null;
        if (view_p != null && (representedElement = view_p.getElement()) instanceof DSemanticDecorator) {
            result = (DSemanticDecorator)representedElement;
        }
        return result;
    }

    public static EObject getSemanticElement(DSemanticDecorator siriusElt_p) {
        EObject result = null;
        if (siriusElt_p != null) {
            result = siriusElt_p.getTarget();
        }
        return result;
    }

    public static EObject toSemanticLevel(Object element_p) {
        EObject result = null;
        Object current = element_p;
        if (current instanceof EditPart) {
            current = LayerUtil.getGmfElement((EditPart)current);
        }
        if (current instanceof View) {
            current = LayerUtil.getSiriusElement((View)current);
        }
        if (current instanceof DSemanticDecorator) {
            result = LayerUtil.getSemanticElement((DSemanticDecorator)current);
        }
        return result;
    }

    public static List<View> toGmf(Iterable<? extends EditPart> editParts_p) {
        ArrayList<View> result = new ArrayList<View>();
        for (EditPart editPart : editParts_p) {
            View view = LayerUtil.getGmfElement(editPart);
            if (view == null) continue;
            result.add(view);
        }
        return result;
    }

    public static List<DSemanticDecorator> toSirius(Iterable<? extends View> views_p) {
        ArrayList<DSemanticDecorator> result = new ArrayList<DSemanticDecorator>();
        for (View view : views_p) {
            DSemanticDecorator siriusElement = LayerUtil.getSiriusElement(view);
            if (siriusElement == null) continue;
            result.add(siriusElement);
        }
        return result;
    }

    public static List<EObject> toSemanticLevel(Iterable<?> elements_p) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (Object current : elements_p) {
            EObject semanticElement = LayerUtil.toSemanticLevel(current);
            if (semanticElement == null) continue;
            result.add(semanticElement);
        }
        return result;
    }

    public static View getUpGmfElement(DSemanticDecorator siriusElement_p) {
        EObject result = MiscUtil.getOpposite((EObject)siriusElement_p, NotationPackage.eINSTANCE.getView_Element());
        return (View)result;
    }

    public static DSemanticDecorator getUpSiriusElement(EObject semanticElement_p) {
        EObject result = MiscUtil.getOpposite(semanticElement_p, ViewpointPackage.eINSTANCE.getDSemanticDecorator_Target());
        return (DSemanticDecorator)result;
    }

    public static List<View> upToGmf(Iterable<? extends DSemanticDecorator> siriusElements_p) {
        ArrayList<View> result = new ArrayList<View>();
        for (DSemanticDecorator dSemanticDecorator : siriusElements_p) {
            View view = LayerUtil.getUpGmfElement(dSemanticDecorator);
            if (view == null) continue;
            result.add(view);
        }
        return result;
    }

    public static List<DSemanticDecorator> upToSirius(Iterable<? extends EObject> semanticElements) {
        ArrayList<DSemanticDecorator> result = new ArrayList<DSemanticDecorator>();
        for (EObject eObject : semanticElements) {
            DSemanticDecorator siriusElement = LayerUtil.getUpSiriusElement(eObject);
            if (siriusElement == null) continue;
            result.add(siriusElement);
        }
        return result;
    }

    public static Set<IGraphicalEditPart> getAllGraphicalParts(Collection<EObject> semanticElements) {
        SiriusDiagramEditor diagramEditor;
        IDiagramGraphicalViewer diagramGraphicalViewer;
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor instanceof SiriusDiagramEditor && (diagramGraphicalViewer = (diagramEditor = (SiriusDiagramEditor)activeEditor).getDiagramGraphicalViewer()) instanceof IDiagramDialectGraphicalViewer) {
            IDiagramDialectGraphicalViewer dialectViewer = (IDiagramDialectGraphicalViewer)diagramGraphicalViewer;
            return semanticElements.stream().flatMap(semantic -> dialectViewer.findEditPartsForElement(semantic, IGraphicalEditPart.class).stream()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public static Set<IGraphicalEditPart> getAllGraphicalParts(EObject ... semanticElements) {
        return LayerUtil.getAllGraphicalParts(Arrays.asList(semanticElements));
    }

    public static IGraphicalEditPart getGraphicalPart(DSemanticDecorator view) {
        Set<IGraphicalEditPart> allEditParts = LayerUtil.getAllGraphicalParts(view.getTarget());
        IGraphicalEditPart graphicalEditPart = null;
        Iterator<IGraphicalEditPart> iterator = allEditParts.iterator();
        while (iterator.hasNext()) {
            IGraphicalEditPart editPart = iterator.next();
            if (!(editPart instanceof IDiagramNameEditPart)) continue;
            iterator.remove();
        }
        if (allEditParts.size() == 1) {
            graphicalEditPart = allEditParts.iterator().next();
        } else {
            for (IGraphicalEditPart currentGraphicalEditPart : allEditParts) {
                if (currentGraphicalEditPart instanceof IDiagramEdgeEditPart) continue;
                graphicalEditPart = currentGraphicalEditPart;
                break;
            }
        }
        return graphicalEditPart;
    }
}

