/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.decomposition;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItem;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionUtil;

public class DecompositionControlDecoration
extends ControlDecoration {
    private int offset = 0;
    private FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");

    public DecompositionControlDecoration(Control control_p, int position_p) {
        super(control_p, position_p);
        Tree tree = (Tree)control_p;
        tree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e_p) {
            }

            public void widgetSelected(SelectionEvent e_p) {
                DecompositionControlDecoration.this.refresh();
            }
        });
        tree.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e_p) {
                DecompositionControlDecoration.this.refresh();
            }

            public void treeExpanded(TreeEvent e_p) {
                DecompositionControlDecoration.this.refresh();
            }
        });
        tree.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e_p) {
                DecompositionControlDecoration.this.refresh();
            }
        });
    }

    public void refresh() {
        this.update();
        this.getControl().getParent().redraw();
    }

    protected Rectangle getDecorationRectangle(Control targetControl_p) {
        Rectangle oldRect = super.getDecorationRectangle(targetControl_p);
        Tree tree = (Tree)this.getControl();
        if (tree.getSelection().length > 0) {
            TreeItem item = tree.getSelection()[0];
            this.offset = item.getBounds().height * 2;
            Image img = this.getImage();
            this.offset -= img != null ? img.getBounds().height : 0;
            oldRect.y = item.getBounds().y + this.offset;
            Rectangle clientArea = tree.getBounds();
            if (oldRect.y > clientArea.height + clientArea.y) {
                oldRect.y = clientArea.height + clientArea.y - this.offset / 2;
            }
            if (oldRect.y < clientArea.y) {
                oldRect.y = clientArea.y;
            }
        }
        return oldRect;
    }

    public Image getImage() {
        Image img = null;
        DecompositionItem decompositionItem = this.getSelectedDecompositionItem();
        if (decompositionItem == null) {
            return img;
        }
        img = this.fieldDecoration.getImage();
        return img;
    }

    public String getDescriptionText() {
        String description = super.getDescriptionText();
        DecompositionItem decompositionItem = this.getSelectedDecompositionItem();
        if (decompositionItem == null) {
            return description;
        }
        switch (decompositionItem.getStatus()) {
            case 1: {
                description = DecompositionUtil.ONCE_USED;
                break;
            }
            case 3: {
                description = DecompositionUtil.MULTIPLE_USED;
                break;
            }
            case 2: {
                description = DecompositionUtil.UNUSED;
                break;
            }
            default: {
                description = super.getDescriptionText();
            }
        }
        return description;
    }

    private DecompositionItem getSelectedDecompositionItem() {
        TreeItem item;
        Object data;
        Tree tree = (Tree)this.getControl();
        if (tree.getSelection().length > 0 && (data = (item = tree.getSelection()[0]).getData()) instanceof DecompositionItem) {
            return (DecompositionItem)data;
        }
        return null;
    }
}

