/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.quickfix.resolver;

import java.util.Collections;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.ui.quickfix.FaQuickFixActivator;
import org.polarsys.capella.core.data.fa.validation.functionPort.DCOM_21_UnusedExchangeItems;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public class DCOM_21_RemoveUnusedExchangeItemsResolver
extends AbstractCapellaMarkerResolution {
    public void run(IMarker marker) {
        final FunctionPort port = (FunctionPort)this.getModelElements(marker).get(0);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)port);
        if (domain != null) {
            RecordingCommand removeCommand = new RecordingCommand(domain){

                protected void doExecute() {
                    EList toUpdate = Collections.emptyList();
                    if (port instanceof FunctionInputPort) {
                        toUpdate = ((FunctionInputPort)port).getIncomingExchangeItems();
                    } else if (port instanceof FunctionOutputPort) {
                        toUpdate = ((FunctionOutputPort)port).getOutgoingExchangeItems();
                    }
                    toUpdate.removeAll(DCOM_21_UnusedExchangeItems.getUnusedExchangeItems((FunctionPort)port));
                }
            };
            domain.getCommandStack().execute((Command)removeCommand);
            try {
                marker.delete();
            }
            catch (CoreException e) {
                Status s = new Status(e.getStatus().getSeverity(), FaQuickFixActivator.getDefault().getPluginId(), e.getStatus().getMessage(), (Throwable)e);
                FaQuickFixActivator.getDefault().getLog().log((IStatus)s);
            }
        }
    }
}

